/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.inbuild;

import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.Context;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.ParsingException;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.Token;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.node.TagPart;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.Transformation;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.kyori.adventure.key.InvalidKeyException;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.nbt.api.BinaryTagHolder;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.examination.Examinable;
import net.kyori.examination.ExaminableProperty;

public final class HoverTransformation
extends Transformation {
    private final HoverEvent.Action<Object> action;
    private final Object value;

    public static HoverTransformation create(Context ctx, String name, List<TagPart> args2) {
        Examinable value;
        if (args2.size() < 2) {
            throw new ParsingException("Doesn't know how to turn " + args2 + " into a hover event", args2);
        }
        List<TagPart> newArgs2 = args2.subList(1, args2.size());
        HoverEvent.Action<Object> action = HoverEvent.Action.NAMES.value(args2.get(0).value());
        if (action == HoverEvent.Action.SHOW_TEXT) {
            value = ctx.parse(newArgs2.get(0).value());
        } else if (action == HoverEvent.Action.SHOW_ITEM) {
            value = HoverTransformation.parseShowItem(newArgs2);
        } else if (action == HoverEvent.Action.SHOW_ENTITY) {
            value = HoverTransformation.parseShowEntity(newArgs2, ctx);
        } else {
            throw new ParsingException("Don't know how to turn '" + args2 + "' into a hover event", args2);
        }
        return new HoverTransformation(action, value);
    }

    private static @NotNull HoverEvent.ShowItem parseShowItem(@NotNull List<TagPart> args2) {
        try {
            if (args2.isEmpty()) {
                throw new ParsingException("Show item hover needs at least item id!", new Token[0]);
            }
            Key key = Key.key(args2.get(0).value());
            int count2 = args2.size() >= 2 ? Integer.parseInt(args2.get(1).value()) : 1;
            if (args2.size() == 3) {
                return HoverEvent.ShowItem.of(key, count2, BinaryTagHolder.of(args2.get(2).value()));
            }
            return HoverEvent.ShowItem.of(key, count2);
        }
        catch (NumberFormatException | InvalidKeyException ex) {
            throw new ParsingException("Exception parsing show_item hover", (Throwable)ex, args2);
        }
    }

    private static @NotNull HoverEvent.ShowEntity parseShowEntity(@NotNull List<TagPart> args2, Context context) {
        try {
            if (args2.size() < 2) {
                throw new ParsingException("Show entity hover needs at least type and uuid!", new Token[0]);
            }
            Key key = Key.key(args2.get(0).value());
            UUID id2 = UUID.fromString(args2.get(1).value());
            if (args2.size() == 3) {
                Component name = context.parse(args2.get(2).value());
                return HoverEvent.ShowEntity.of(key, id2, name);
            }
            return HoverEvent.ShowEntity.of(key, id2);
        }
        catch (IllegalArgumentException | InvalidKeyException ex) {
            throw new ParsingException("Exception parsing show_entity hover", (Throwable)ex, args2);
        }
    }

    private HoverTransformation(HoverEvent.Action<Object> action, Object value) {
        this.action = action;
        this.value = value;
    }

    @Override
    public Component apply() {
        return Component.empty().hoverEvent(HoverEvent.hoverEvent(this.action, this.value));
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("action", this.action), ExaminableProperty.of("value", this.value));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        HoverTransformation that = (HoverTransformation)other;
        return Objects.equals(this.action, that.action) && Objects.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.action, this.value);
    }
}

