/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.inbuild;

import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.ParsingException;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.node.ElementNode;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.node.TagNode;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.node.TagPart;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.node.ValueNode;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.Modifying;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.Transformation;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.inbuild.TemplateTransformation;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.PrimitiveIterator;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.examination.ExaminableProperty;

public final class RainbowTransformation
extends Transformation
implements Modifying {
    private int size;
    private int disableApplyingColorDepth = -1;
    private int colorIndex = 0;
    private float center = 128.0f;
    private float width = 127.0f;
    private double frequency = 1.0;
    private final boolean reversed;
    private final int phase;

    public static RainbowTransformation create(String name, List<TagPart> args2) {
        boolean reversed = false;
        int phase = 0;
        if (args2.size() == 1) {
            String value = args2.get(0).value();
            if (args2.get(0).value().startsWith("!")) {
                reversed = true;
                value = value.replaceFirst("!", "");
            }
            if (value.length() > 0) {
                try {
                    phase = Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    throw new ParsingException("Expected phase, got " + args2.get(0), args2);
                }
            }
        }
        return new RainbowTransformation(reversed, phase);
    }

    private RainbowTransformation(boolean reversed, int phase) {
        this.reversed = reversed;
        this.phase = phase;
    }

    @Override
    public void visit(ElementNode curr) {
        TagNode tag;
        if (curr instanceof ValueNode) {
            String value = ((ValueNode)curr).value();
            this.size += value.codePointCount(0, value.length());
        } else if (curr instanceof TagNode && (tag = (TagNode)curr).transformation() instanceof TemplateTransformation) {
            ComponentFlattener.textOnly().flatten(tag.transformation().apply(), s2 -> this.size += s2.codePointCount(0, s2.length()));
        }
    }

    @Override
    public Component apply() {
        this.center = 128.0f;
        this.width = 127.0f;
        this.frequency = Math.PI * 2 / (double)this.size;
        return Component.empty();
    }

    @Override
    public Component apply(Component current, int depth) {
        if (this.disableApplyingColorDepth != -1 && depth > this.disableApplyingColorDepth || current.style().color() != null) {
            if (this.disableApplyingColorDepth == -1) {
                this.disableApplyingColorDepth = depth;
            }
            if (current instanceof TextComponent) {
                String content = ((TextComponent)current).content();
                int len = content.codePointCount(0, content.length());
                for (int i = 0; i < len; ++i) {
                    this.color(this.phase);
                }
            }
            return current.children(Collections.emptyList());
        }
        this.disableApplyingColorDepth = -1;
        if (current instanceof TextComponent && ((TextComponent)current).content().length() > 0) {
            TextComponent textComponent = (TextComponent)current;
            String content = textComponent.content();
            TextComponent.Builder parent = Component.text();
            if (this.colorIndex == 0 && this.reversed) {
                this.colorIndex = this.size - 1;
            }
            int[] holder = new int[1];
            PrimitiveIterator.OfInt it = content.codePoints().iterator();
            while (it.hasNext()) {
                holder[0] = it.nextInt();
                TextComponent comp = Component.text(new String(holder, 0, 1), this.color(this.phase));
                parent.append((Component)comp);
            }
            return parent.build();
        }
        return Component.empty().mergeStyle(current);
    }

    private TextColor color(float phase) {
        int n;
        if (this.reversed) {
            int n2 = this.colorIndex;
            n = n2;
            this.colorIndex = n2 - 1;
        } else {
            int n3 = this.colorIndex;
            n = n3;
            this.colorIndex = n3 + 1;
        }
        int index = n;
        int red = (int)(Math.sin(this.frequency * (double)index + 2.0 + (double)phase) * (double)this.width + (double)this.center);
        int green = (int)(Math.sin(this.frequency * (double)index + 0.0 + (double)phase) * (double)this.width + (double)this.center);
        int blue = (int)(Math.sin(this.frequency * (double)index + 4.0 + (double)phase) * (double)this.width + (double)this.center);
        return TextColor.color(red, green, blue);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.phase));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RainbowTransformation that = (RainbowTransformation)other;
        return this.colorIndex == that.colorIndex && Float.compare(that.center, this.center) == 0 && Float.compare(that.width, this.width) == 0 && Double.compare(that.frequency, this.frequency) == 0 && this.phase == that.phase;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.colorIndex, Float.valueOf(this.center), Float.valueOf(this.width), this.frequency, this.phase);
    }
}

