/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.inbuild;

import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.Context;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.ParsingException;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.parser.node.TagPart;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.Inserting;
import com.willfp.eco.internal.spigot.proxy.v1_17_R1.minimessage.transformation.Transformation;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.examination.ExaminableProperty;

public final class TranslatableTransformation
extends Transformation
implements Inserting {
    private final String key;
    private final List<Component> inners;

    public static TranslatableTransformation create(Context ctx, String name, List<TagPart> args2) {
        List<Component> with;
        if (args2.isEmpty()) {
            throw new ParsingException("Doesn't know how to turn " + args2 + " into a translatable component", args2);
        }
        if (args2.size() > 1) {
            with = new ArrayList();
            for (TagPart in : args2.subList(1, args2.size())) {
                with.add(ctx.parse(in.value()));
            }
        } else {
            with = Collections.emptyList();
        }
        return new TranslatableTransformation(args2.get(0).value(), with);
    }

    private TranslatableTransformation(String key, List<Component> with) {
        this.key = key;
        this.inners = with;
    }

    @Override
    public Component apply() {
        if (this.inners.isEmpty()) {
            return Component.translatable(this.key);
        }
        return Component.translatable(this.key, this.inners);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("key", this.key), ExaminableProperty.of("inners", this.inners));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        TranslatableTransformation that = (TranslatableTransformation)other;
        return Objects.equals(this.key, that.key) && Objects.equals(this.inners, that.inners);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.inners);
    }
}

