/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser.node;

import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.Template;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser.ParsingException;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser.Token;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser.node.ElementNode;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser.node.TagPart;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.template.TemplateResolver;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.transformation.Transformation;
import com.willfp.eco.libs.jetbrains.annotations.ApiStatus;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class TagNode
extends ElementNode {
    private final List<TagPart> parts;
    @Nullable
    private Transformation transformation = null;

    @Deprecated
    @ApiStatus.ScheduledForRemoval
    public TagNode(@NotNull ElementNode parent, @NotNull Token token2, @NotNull String sourceMessage, @NotNull Map<String, Template> templates) {
        this(parent, token2, sourceMessage, TemplateResolver.pairs(templates));
    }

    public TagNode(@NotNull ElementNode parent, @NotNull Token token2, @NotNull String sourceMessage, @NotNull TemplateResolver templateResolver) {
        super(parent, token2, sourceMessage);
        this.parts = TagNode.genParts(token2, sourceMessage, templateResolver);
    }

    @NotNull
    private static List<TagPart> genParts(@NotNull Token token2, @NotNull String sourceMessage, @NotNull TemplateResolver templateResolver) {
        ArrayList<TagPart> parts = new ArrayList<TagPart>();
        if (token2.childTokens() != null) {
            for (Token childToken : token2.childTokens()) {
                parts.add(new TagPart(sourceMessage, childToken, templateResolver));
            }
        }
        return parts;
    }

    @NotNull
    public List<TagPart> parts() {
        return this.parts;
    }

    @NotNull
    public String name() {
        if (this.parts.isEmpty()) {
            throw new ParsingException("Tag has no parts? " + this, this.sourceMessage(), this.token());
        }
        return this.parts.get(0).value();
    }

    @Override
    @NotNull
    public Token token() {
        return Objects.requireNonNull(super.token(), "token is not set");
    }

    @NotNull
    public Transformation transformation() {
        return Objects.requireNonNull(this.transformation, "no transformation set");
    }

    public void transformation(@NotNull Transformation transformation) {
        this.transformation = transformation;
    }

    @Override
    @NotNull
    public StringBuilder buildToString(@NotNull StringBuilder sb, int indent) {
        char[] in = this.ident(indent);
        sb.append(in).append("TagNode(");
        int size = this.parts.size();
        for (int i = 0; i < size; ++i) {
            TagPart part = this.parts.get(i);
            sb.append('\'').append(part.value()).append('\'');
            if (i == size - 1) continue;
            sb.append(", ");
        }
        sb.append(") {\n");
        for (ElementNode child : this.children()) {
            child.buildToString(sb, indent + 1);
        }
        sb.append(in).append("}\n");
        return sb;
    }
}

