/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.template;

import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.Template;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.template.TemplateResolver;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.function.Function;
import net.kyori.adventure.text.ComponentLike;

final class DynamicTemplateResolver
implements TemplateResolver {
    private final Function<String, ?> resolver;

    DynamicTemplateResolver(Function<String, ?> resolver) {
        this.resolver = resolver;
    }

    @Override
    public boolean canResolve(@NotNull String key) {
        Object result2 = this.resolver.apply(key);
        return result2 instanceof String || result2 instanceof ComponentLike || result2 instanceof Template;
    }

    @Override
    @Nullable
    public Template resolve(@NotNull String key) {
        Object result2 = this.resolver.apply(key);
        if (result2 == null) {
            return null;
        }
        if (result2 instanceof String) {
            return Template.template(key, (String)result2);
        }
        if (result2 instanceof ComponentLike) {
            return Template.template(key, (ComponentLike)result2);
        }
        if (result2 instanceof Template) {
            return (Template)result2;
        }
        throw new IllegalArgumentException("Dynamic template resolver must return instances of String or ComponentLike, instead found " + result2.getClass().getName());
    }
}

