/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.transformation.inbuild;

import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser.ParsingException;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser.node.TagPart;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.transformation.Transformation;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.examination.ExaminableProperty;

public final class DecorationTransformation
extends Transformation {
    public static final Map<String, TextDecoration> DECORATION_ALIASES;
    private final TextDecoration decoration;

    public static DecorationTransformation create(String name, List<TagPart> args2) {
        @Nullable TextDecoration decoration = DecorationTransformation.parseDecoration(name);
        if (decoration == null) {
            throw new ParsingException("Don't know how to turn '" + name + "' into a decoration", args2);
        }
        return new DecorationTransformation(decoration);
    }

    private static TextDecoration parseDecoration(String name) {
        TextDecoration alias = DECORATION_ALIASES.get(name);
        return alias != null ? alias : TextDecoration.NAMES.value(name);
    }

    private DecorationTransformation(TextDecoration decoration) {
        this.decoration = decoration;
    }

    @Override
    public Component apply() {
        return Component.empty().decorate(this.decoration);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("decoration", this.decoration));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        DecorationTransformation that = (DecorationTransformation)other;
        return this.decoration == that.decoration;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.decoration);
    }

    static {
        HashMap<String, TextDecoration> aliases = new HashMap<String, TextDecoration>();
        aliases.put("b", TextDecoration.BOLD);
        aliases.put("em", TextDecoration.ITALIC);
        aliases.put("i", TextDecoration.ITALIC);
        aliases.put("u", TextDecoration.UNDERLINED);
        aliases.put("st", TextDecoration.STRIKETHROUGH);
        aliases.put("obf", TextDecoration.OBFUSCATED);
        DECORATION_ALIASES = Collections.unmodifiableMap(aliases);
    }
}

