/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.transformation.inbuild;

import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser.ParsingException;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.parser.node.TagPart;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.transformation.Inserting;
import com.willfp.eco.internal.spigot.proxy.v1_18_R1.minimessage.transformation.Transformation;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.text.Component;
import net.kyori.examination.ExaminableProperty;

public final class KeybindTransformation
extends Transformation
implements Inserting {
    private final String keybind;

    public static KeybindTransformation create(String name, List<TagPart> args2) {
        if (args2.size() != 1) {
            throw new ParsingException("Doesn't know how to turn token with name '" + name + "' and arguments " + args2 + " into a keybind component", args2);
        }
        return new KeybindTransformation(args2.get(0).value());
    }

    private KeybindTransformation(String keybind) {
        this.keybind = keybind;
    }

    @Override
    public Component apply() {
        return Component.keybind(this.keybind);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("keybind", this.keybind));
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        KeybindTransformation that = (KeybindTransformation)other;
        return Objects.equals(this.keybind, that.keybind);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keybind);
    }
}

