/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_18_R2.minimessage.internal.parser.match;

import com.willfp.eco.internal.spigot.proxy.v1_18_R2.minimessage.internal.parser.TokenParser;
import com.willfp.eco.internal.spigot.proxy.v1_18_R2.minimessage.internal.parser.TokenType;
import com.willfp.eco.internal.spigot.proxy.v1_18_R2.minimessage.internal.parser.match.MatchedTokenConsumer;
import com.willfp.eco.internal.spigot.proxy.v1_18_R2.minimessage.tag.PreProcess;
import com.willfp.eco.internal.spigot.proxy.v1_18_R2.minimessage.tag.Tag;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Objects;

public final class StringResolvingMatchedTokenConsumer
extends MatchedTokenConsumer<String> {
    private final StringBuilder builder;
    private final TokenParser.TagProvider tagProvider;

    public StringResolvingMatchedTokenConsumer(@NotNull String input, @NotNull TokenParser.TagProvider tagProvider) {
        super(input);
        this.builder = new StringBuilder(input.length());
        this.tagProvider = tagProvider;
    }

    @Override
    public void accept(int start, int end, @NotNull TokenType tokenType) {
        super.accept(start, end, tokenType);
        if (tokenType != TokenType.OPEN_TAG) {
            this.builder.append(this.input, start, end);
        } else {
            String match = this.input.substring(start, end);
            String tag = this.input.substring(start + 1, end - 1);
            @Nullable Tag replacement = this.tagProvider.resolve(TokenParser.TagProvider.sanitizePlaceholderName(tag));
            if (replacement instanceof PreProcess) {
                this.builder.append(Objects.requireNonNull(((PreProcess)replacement).value(), "PreProcess replacements cannot return null"));
                return;
            }
            this.builder.append(match);
        }
    }

    @Override
    @NotNull
    public String result() {
        return this.builder.toString();
    }
}

