/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_19_R1.common.item;

import com.willfp.eco.core.fast.FastItemStack;
import com.willfp.eco.internal.spigot.proxy.v1_19_R1.common.NMSCommonsKt;
import com.willfp.eco.internal.spigot.proxy.v1_19_R1.common.item.ContinuallyAppliedPersistentDataContainer;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.util.NamespacedKeyUtils;
import com.willfp.eco.util.StringUtils;
import com.willfp.eco.util.StringUtilsExtensions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemEnchantedBook;
import net.minecraft.world.item.Items;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J!\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\r\u0010\u0018\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0019J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0011H\u0016J\u0010\u0010!\u001a\u00020\u00062\u0006\u0010\"\u001a\u00020\u0016H\u0002J\u000f\u0010#\u001a\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010$J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020(H\u0016J\u0018\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u001bH\u0016J\u001c\u0010-\u001a\u000e\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020\u001f0.2\u0006\u0010,\u001a\u00020\u001bH\u0016J\u000e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001600H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020&02H\u0016J\u000e\u00103\u001a\b\u0012\u0004\u0012\u00020(02H\u0016J\b\u00104\u001a\u00020\u0011H\u0016J\b\u00105\u001a\u00020\u001fH\u0016J\b\u00106\u001a\u000207H\u0016J\u0010\u00108\u001a\u00020\u001b2\u0006\u00109\u001a\u00020\u0016H\u0016J\b\u0010:\u001a\u00020\u001fH\u0016J!\u0010;\u001a\u00020\u00132\u0012\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\"\u00020\u0016H\u0016\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010<\u001a\u00020\u00132\u0006\u0010=\u001a\u00020\u001fH\u0016J\u0012\u0010>\u001a\u00020\u00132\b\u0010?\u001a\u0004\u0018\u00010\u0011H\u0016J\u0017\u0010@\u001a\u00020\u00132\b\u0010A\u001a\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010BJ\u0012\u0010C\u001a\u00020\u00132\b\u0010D\u001a\u0004\u0018\u00010&H\u0016J\u0012\u0010C\u001a\u00020\u00132\b\u0010D\u001a\u0004\u0018\u00010(H\u0016J\u0018\u0010E\u001a\u00020\u00132\u000e\u0010F\u001a\n\u0012\u0004\u0012\u00020&\u0018\u000102H\u0016J\u0018\u0010G\u001a\u00020\u00132\u000e\u0010F\u001a\n\u0012\u0004\u0012\u00020(\u0018\u000102H\u0016J\u0010\u0010H\u001a\u00020\u00132\u0006\u0010I\u001a\u00020\u001fH\u0016J\u0010\u0010J\u001a\u00020\u00132\u0006\u0010K\u001a\u000207H\u0016J\b\u0010L\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068B@BX\u0082\u000e\u00a2\u0006\u0012\u0012\u0004\b\b\u0010\t\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006M"}, d2={"Lcom/willfp/eco/internal/spigot/proxy/v1_19_R1/common/item/EcoFastItemStack;", "Lcom/willfp/eco/core/fast/FastItemStack;", "bukkit", "Lorg/bukkit/inventory/ItemStack;", "(Lorg/bukkit/inventory/ItemStack;)V", "value", "", "flagBits", "getFlagBits$annotations", "()V", "getFlagBits", "()B", "setFlagBits", "(B)V", "handle", "Lnet/minecraft/world/item/ItemStack;", "pdc", "Lorg/bukkit/persistence/PersistentDataContainer;", "addItemFlags", "", "hideFlags", "", "Lorg/bukkit/inventory/ItemFlag;", "([Lorg/bukkit/inventory/ItemFlag;)V", "apply", "apply$nms_common", "equals", "", "other", "", "getAmount", "", "getBaseTag", "getBitModifier", "hideFlag", "getCustomModelData", "()Ljava/lang/Integer;", "getDisplayName", "", "getDisplayNameComponent", "Lnet/kyori/adventure/text/Component;", "getEnchantmentLevel", "enchantment", "Lorg/bukkit/enchantments/Enchantment;", "checkStored", "getEnchants", "", "getItemFlags", "", "getLore", "", "getLoreComponents", "getPersistentDataContainer", "getRepairCost", "getType", "Lorg/bukkit/Material;", "hasItemFlag", "flag", "hashCode", "removeItemFlags", "setAmount", "amount", "setBaseTag", "container", "setCustomModelData", "data", "(Ljava/lang/Integer;)V", "setDisplayName", "name", "setLore", "lore", "setLoreComponents", "setRepairCost", "cost", "setType", "material", "unwrap", "nms-common"})
@SourceDebugExtension(value={"SMAP\nEcoFastItemStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EcoFastItemStack.kt\ncom/willfp/eco/internal/spigot/proxy/common/item/EcoFastItemStack\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,293:1\n1549#2:294\n1620#2,3:295\n1549#2:298\n1620#2,3:299\n1549#2:302\n1620#2,3:303\n*S KotlinDebug\n*F\n+ 1 EcoFastItemStack.kt\ncom/willfp/eco/internal/spigot/proxy/common/item/EcoFastItemStack\n*L\n79#1:294\n79#1:295,3\n121#1:298\n121#1:299,3\n125#1:302\n125#1:303,3\n*E\n"})
public final class EcoFastItemStack
implements FastItemStack {
    @NotNull
    private final ItemStack bukkit;
    @NotNull
    private final net.minecraft.world.item.ItemStack handle;
    @NotNull
    private final PersistentDataContainer pdc;

    public EcoFastItemStack(@NotNull ItemStack bukkit) {
        NBTTagCompound nBTTagCompound;
        Intrinsics.checkNotNullParameter(bukkit, "bukkit");
        this.bukkit = bukkit;
        this.handle = NMSCommonsKt.asNMSStack(this.bukkit);
        if (this.handle.t()) {
            NBTTagCompound nBTTagCompound2 = this.handle.u();
            nBTTagCompound = nBTTagCompound2;
            Intrinsics.checkNotNull(nBTTagCompound2);
        } else {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound nBTTagCompound3 = nBTTagCompound;
        Intrinsics.checkNotNull(nBTTagCompound3);
        this.pdc = NMSCommonsKt.makePdc$default(nBTTagCompound3, false, 1, null);
    }

    @Override
    @NotNull
    public Map<Enchantment, Integer> getEnchants(boolean checkStored) {
        NBTTagList enchantmentNBT = checkStored && this.handle.c() == Items.ss ? ItemEnchantedBook.d((net.minecraft.world.item.ItemStack)this.handle) : this.handle.w();
        Map foundEnchantments = new LinkedHashMap();
        for (NBTBase base : enchantmentNBT) {
            Intrinsics.checkNotNull(base, "null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            NBTTagCompound compound = (NBTTagCompound)base;
            String key = compound.l("id");
            short level = (short)(0xFFFFFFFF & compound.g("lvl"));
            Enchantment found = Enchantment.getByKey((NamespacedKey)NamespacedKeyUtils.fromStringOrNull(key));
            if (found == null) continue;
            Integer n = level;
            foundEnchantments.put(found, n);
        }
        return foundEnchantments;
    }

    @Override
    public int getEnchantmentLevel(@NotNull Enchantment enchantment, boolean checkStored) {
        Intrinsics.checkNotNullParameter(enchantment, "enchantment");
        NBTTagList enchantmentNBT = checkStored && this.handle.c() == Items.ss ? ItemEnchantedBook.d((net.minecraft.world.item.ItemStack)this.handle) : this.handle.w();
        for (NBTBase base : enchantmentNBT) {
            Intrinsics.checkNotNull(base, "null cannot be cast to non-null type net.minecraft.nbt.CompoundTag");
            NBTTagCompound compound = (NBTTagCompound)base;
            String key = compound.l("id");
            if (!Intrinsics.areEqual(key, enchantment.getKey().toString())) continue;
            return (short)(0xFFFFFFFF & compound.g("lvl"));
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLore(@Nullable List<String> lore) {
        List list;
        EcoFastItemStack ecoFastItemStack = this;
        List<String> list2 = lore;
        if (list2 != null) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list2;
            EcoFastItemStack ecoFastItemStack2 = ecoFastItemStack;
            boolean $i$f$map = false;
            void var4_5 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(StringUtilsExtensions.toComponent((String)it));
            }
            list = (List)destination$iv$iv;
            ecoFastItemStack = ecoFastItemStack2;
        } else {
            list = null;
        }
        ecoFastItemStack.setLoreComponents(list);
    }

    public void setLoreComponents(@Nullable List<? extends Component> lore) {
        NBTTagCompound displayTag;
        List jsonLore = new ArrayList();
        if (lore != null) {
            for (Component component : lore) {
                String string = StringUtils.componentToJson(component);
                Intrinsics.checkNotNullExpressionValue(string, "componentToJson(...)");
                jsonLore.add(string);
            }
        }
        if (!(displayTag = this.handle.a("display")).e("Lore")) {
            displayTag.a("Lore", (NBTBase)new NBTTagList());
        }
        NBTTagList nBTTagList = displayTag.c("Lore", NMSCommonsKt.getNBT_TAG_STRING());
        nBTTagList.clear();
        for (String s3 : jsonLore) {
            nBTTagList.add((Object)NBTTagString.a((String)s3));
        }
        this.apply$nms_common();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Component> getLoreComponents() {
        void $this$mapTo$iv$iv;
        NBTTagCompound nBTTagCompound = this.handle.b("display");
        if (nBTTagCompound == null) {
            return CollectionsKt.emptyList();
        }
        NBTTagCompound displayTag = nBTTagCompound;
        if (!displayTag.e("Lore")) {
            return CollectionsKt.emptyList();
        }
        NBTTagList loreTag = displayTag.c("Lore", NMSCommonsKt.getNBT_TAG_STRING());
        List jsonLore = new ArrayList();
        int n = loreTag.size();
        for (int i = 0; i < n; ++i) {
            String string = loreTag.j(i);
            Intrinsics.checkNotNullExpressionValue(string, "getString(...)");
            jsonLore.add(string);
        }
        Iterable $this$map$iv = jsonLore;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringUtils.jsonToComponent((String)it));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getLore() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.getLoreComponents();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Component component = (Component)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(StringUtils.toLegacy((Component)it));
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void setDisplayName(@Nullable Component name) {
        NBTTagCompound displayTag = this.handle.a("display");
        displayTag.r("Name");
        if (name != null) {
            displayTag.a("Name", (NBTBase)NBTTagString.a((String)StringUtils.componentToJson(name)));
        }
        this.apply$nms_common();
    }

    @Override
    public void setDisplayName(@Nullable String name) {
        String string = name;
        this.setDisplayName(string != null ? StringUtilsExtensions.toComponent(string) : null);
    }

    @Override
    @NotNull
    public Component getDisplayNameComponent() {
        NBTTagCompound nBTTagCompound = this.handle.b("display");
        if (nBTTagCompound == null) {
            Material material = this.bukkit.getType();
            Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
            TranslatableComponent translatableComponent = Component.translatable(NMSCommonsKt.toItem(material).a());
            Intrinsics.checkNotNullExpressionValue(translatableComponent, "translatable(...)");
            return translatableComponent;
        }
        NBTTagCompound displayTag = nBTTagCompound;
        if (!displayTag.e("Name")) {
            Material material = this.bukkit.getType();
            Intrinsics.checkNotNullExpressionValue(material, "getType(...)");
            TranslatableComponent translatableComponent = Component.translatable(NMSCommonsKt.toItem(material).a());
            Intrinsics.checkNotNullExpressionValue(translatableComponent, "translatable(...)");
            return translatableComponent;
        }
        String nameTag = displayTag.l("Name");
        Component component = StringUtils.jsonToComponent(nameTag);
        Intrinsics.checkNotNullExpressionValue(component, "jsonToComponent(...)");
        return component;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return StringUtilsExtensions.toLegacy(this.getDisplayNameComponent());
    }

    @Override
    public void addItemFlags(ItemFlag ... hideFlags) {
        Intrinsics.checkNotNullParameter(hideFlags, "hideFlags");
        for (ItemFlag f : hideFlags) {
            this.setFlagBits((byte)(this.getFlagBits() | this.getBitModifier(f)));
        }
        this.apply$nms_common();
    }

    @Override
    public void removeItemFlags(ItemFlag ... hideFlags) {
        Intrinsics.checkNotNullParameter(hideFlags, "hideFlags");
        for (ItemFlag f : hideFlags) {
            this.setFlagBits((byte)(this.getFlagBits() & (byte)(~this.getBitModifier(f))));
        }
        this.apply$nms_common();
    }

    @Override
    @NotNull
    public Set<ItemFlag> getItemFlags() {
        Set currentFlags = new LinkedHashSet();
        for (ItemFlag f : ItemFlag.values()) {
            if (!this.hasItemFlag(f)) continue;
            currentFlags.add(f);
        }
        return currentFlags;
    }

    @Override
    public boolean hasItemFlag(@NotNull ItemFlag flag) {
        Intrinsics.checkNotNullParameter(flag, "flag");
        byte bitModifier = this.getBitModifier(flag);
        return (byte)(this.getFlagBits() & bitModifier) == bitModifier;
    }

    @Override
    @NotNull
    public PersistentDataContainer getBaseTag() {
        NBTTagCompound nBTTagCompound;
        if (this.handle.t()) {
            NBTTagCompound nBTTagCompound2 = this.handle.u();
            nBTTagCompound = nBTTagCompound2;
            Intrinsics.checkNotNull(nBTTagCompound2);
        } else {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound nBTTagCompound3 = nBTTagCompound;
        Intrinsics.checkNotNull(nBTTagCompound3);
        return NMSCommonsKt.makePdc(nBTTagCompound3, true);
    }

    @Override
    public void setBaseTag(@Nullable PersistentDataContainer container) {
        NBTTagCompound nBTTagCompound;
        if (this.handle.t()) {
            NBTTagCompound nBTTagCompound2 = this.handle.u();
            nBTTagCompound = nBTTagCompound2;
            Intrinsics.checkNotNull(nBTTagCompound2);
        } else {
            nBTTagCompound = new NBTTagCompound();
        }
        NBTTagCompound nBTTagCompound3 = nBTTagCompound;
        Intrinsics.checkNotNull(nBTTagCompound3);
        NMSCommonsKt.setPdc(nBTTagCompound3, container, this.handle);
        this.apply$nms_common();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final byte getFlagBits() {
        if (!this.handle.t()) return 0;
        NBTTagCompound nBTTagCompound = this.handle.u();
        Intrinsics.checkNotNull(nBTTagCompound);
        if (!nBTTagCompound.b("HideFlags", 99)) return 0;
        NBTTagCompound nBTTagCompound2 = this.handle.u();
        Intrinsics.checkNotNull(nBTTagCompound2);
        byte by = (byte)nBTTagCompound2.h("HideFlags");
        return by;
    }

    private final void setFlagBits(byte value) {
        this.handle.v().a("HideFlags", (int)value);
    }

    private static /* synthetic */ void getFlagBits$annotations() {
    }

    @Override
    public int getRepairCost() {
        return this.handle.H();
    }

    @Override
    public void setRepairCost(int cost) {
        this.handle.c(cost);
        this.apply$nms_common();
    }

    @NotNull
    public PersistentDataContainer getPersistentDataContainer() {
        return new ContinuallyAppliedPersistentDataContainer(this.pdc, this);
    }

    @Override
    public int getAmount() {
        return this.handle.K();
    }

    @Override
    public void setAmount(int amount) {
        this.handle.e(amount);
    }

    @Override
    public void setType(@NotNull Material material) {
        Intrinsics.checkNotNullParameter(material, "material");
        if (material == Material.AIR) {
            this.handle.c(null);
        }
        this.handle.setItem(NMSCommonsKt.toItem(material));
        this.apply$nms_common();
    }

    @Override
    @NotNull
    public Material getType() {
        Item item = this.handle.c();
        Intrinsics.checkNotNullExpressionValue(item, "getItem(...)");
        return NMSCommonsKt.toMaterial(item);
    }

    @Override
    @Nullable
    public Integer getCustomModelData() {
        NBTTagCompound nBTTagCompound = this.handle.u();
        return nBTTagCompound != null ? Integer.valueOf(nBTTagCompound.h("CustomModelData")) : null;
    }

    @Override
    public void setCustomModelData(@Nullable Integer data2) {
        if (data2 == null) {
            NBTTagCompound nBTTagCompound = this.handle.u();
            if (nBTTagCompound == null) {
                return;
            }
            NBTTagCompound tag = nBTTagCompound;
            tag.r("CustomModelData");
        } else {
            this.handle.v().a("CustomModelData", data2.intValue());
        }
        this.apply$nms_common();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof EcoFastItemStack)) {
            return false;
        }
        return ((EcoFastItemStack)other).hashCode() == this.hashCode();
    }

    public int hashCode() {
        NBTTagCompound nBTTagCompound = this.handle.u();
        return nBTTagCompound != null ? nBTTagCompound.hashCode() : 651 + Item.a((Item)this.handle.c());
    }

    public final void apply$nms_common() {
        if (this.handle.t()) {
            NBTTagCompound nBTTagCompound = this.handle.u();
            if (nBTTagCompound != null) {
                NMSCommonsKt.setPdc$default(nBTTagCompound, this.pdc, null, 2, null);
            }
        }
        NMSCommonsKt.mergeIfNeeded(this.bukkit, this.handle);
    }

    private final byte getBitModifier(ItemFlag hideFlag) {
        return (byte)(1 << hideFlag.ordinal());
    }

    @Override
    @NotNull
    public ItemStack unwrap() {
        return this.bukkit;
    }
}

