/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.internal.spigot.proxy.v1_20_R3.minimessage.tag.standard;

import com.willfp.eco.internal.spigot.proxy.v1_20_R3.minimessage.Context;
import com.willfp.eco.internal.spigot.proxy.v1_20_R3.minimessage.tag.Tag;
import com.willfp.eco.internal.spigot.proxy.v1_20_R3.minimessage.tag.resolver.ArgumentQueue;
import com.willfp.eco.internal.spigot.proxy.v1_20_R3.minimessage.tag.resolver.TagResolver;
import com.willfp.eco.internal.spigot.proxy.v1_20_R3.minimessage.tag.standard.AbstractColorChangingTag;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import java.util.Objects;
import java.util.stream.Stream;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.util.ShadyPines;
import net.kyori.examination.ExaminableProperty;

final class RainbowTag
extends AbstractColorChangingTag {
    private static final String REVERSE = "!";
    private static final String RAINBOW = "rainbow";
    static final TagResolver RESOLVER = TagResolver.resolver("rainbow", RainbowTag::create);
    private final boolean reversed;
    private final int phase;
    private float center = 128.0f;
    private float width = 127.0f;
    private double frequency = 1.0;
    private int colorIndex = 0;

    static Tag create(ArgumentQueue args2, Context ctx) {
        boolean reversed = false;
        int phase = 0;
        if (args2.hasNext()) {
            String value = args2.pop().value();
            if (value.startsWith(REVERSE)) {
                reversed = true;
                value = value.substring(REVERSE.length());
            }
            if (value.length() > 0) {
                try {
                    phase = Integer.parseInt(value);
                }
                catch (NumberFormatException ex) {
                    throw ctx.newException("Expected phase, got " + value);
                }
            }
        }
        return new RainbowTag(reversed, phase);
    }

    private RainbowTag(boolean reversed, int phase) {
        this.reversed = reversed;
        this.phase = phase;
    }

    @Override
    protected void init() {
        this.center = 128.0f;
        this.width = 127.0f;
        this.frequency = Math.PI * 2 / (double)this.size();
        if (this.reversed) {
            this.colorIndex = this.size() - 1;
        }
    }

    @Override
    protected void advanceColor() {
        this.colorIndex = this.reversed ? (this.colorIndex == 0 ? this.size() - 1 : --this.colorIndex) : ++this.colorIndex;
    }

    @Override
    protected TextColor color() {
        int index = this.colorIndex;
        int red = (int)(Math.sin(this.frequency * (double)index + 2.0 + (double)this.phase) * (double)this.width + (double)this.center);
        int green = (int)(Math.sin(this.frequency * (double)index + 0.0 + (double)this.phase) * (double)this.width + (double)this.center);
        int blue = (int)(Math.sin(this.frequency * (double)index + 4.0 + (double)this.phase) * (double)this.width + (double)this.center);
        return TextColor.color(red, green, blue);
    }

    @Override
    @NotNull
    public Stream<? extends ExaminableProperty> examinableProperties() {
        return Stream.of(ExaminableProperty.of("phase", this.phase));
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RainbowTag that = (RainbowTag)other;
        return this.colorIndex == that.colorIndex && ShadyPines.equals(that.center, this.center) && ShadyPines.equals(that.width, this.width) && ShadyPines.equals(that.frequency, this.frequency) && this.phase == that.phase;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.colorIndex, Float.valueOf(this.center), Float.valueOf(this.width), this.frequency, this.phase);
    }
}

