/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson;

import com.willfp.eco.libs.bson.BsonBinaryReader;
import com.willfp.eco.libs.bson.BsonType;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.RawBsonArray;
import com.willfp.eco.libs.bson.RawBsonDocument;
import com.willfp.eco.libs.bson.codecs.BsonValueCodecProvider;
import com.willfp.eco.libs.bson.codecs.DecoderContext;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistries;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.bson.io.BsonInputMark;

final class RawBsonValueHelper {
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());

    static BsonValue decode(byte[] bytes, BsonBinaryReader bsonReader) {
        if (bsonReader.getCurrentBsonType() == BsonType.DOCUMENT || bsonReader.getCurrentBsonType() == BsonType.ARRAY) {
            int position = bsonReader.getBsonInput().getPosition();
            BsonInputMark mark = bsonReader.getBsonInput().getMark(4);
            int size = bsonReader.getBsonInput().readInt32();
            mark.reset();
            bsonReader.skipValue();
            if (bsonReader.getCurrentBsonType() == BsonType.DOCUMENT) {
                return new RawBsonDocument(bytes, position, size);
            }
            return new RawBsonArray(bytes, position, size);
        }
        return (BsonValue)REGISTRY.get(BsonValueCodecProvider.getClassForBsonType(bsonReader.getCurrentBsonType())).decode(bsonReader, DecoderContext.builder().build());
    }

    private RawBsonValueHelper() {
    }
}

