/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.codecs;

import com.willfp.eco.libs.annotation.Nullable;
import com.willfp.eco.libs.bson.BsonReader;
import com.willfp.eco.libs.bson.BsonType;
import com.willfp.eco.libs.bson.BsonWriter;
import com.willfp.eco.libs.bson.assertions.Assertions;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.DecoderContext;
import com.willfp.eco.libs.bson.codecs.EncoderContext;
import com.willfp.eco.libs.bson.codecs.configuration.CodecConfigurationException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.function.Supplier;

abstract class AbstractMapCodec<T, M extends Map<String, T>>
implements Codec<M> {
    private final Supplier<M> supplier;
    private final Class<M> clazz;

    AbstractMapCodec(@Nullable Class<M> clazz) {
        this.clazz = Assertions.notNull("clazz", clazz);
        Class rawClass = clazz;
        if (rawClass == Map.class || rawClass == AbstractMap.class || rawClass == HashMap.class) {
            this.supplier = () -> new HashMap();
        } else if (rawClass == NavigableMap.class || rawClass == TreeMap.class) {
            this.supplier = () -> new TreeMap();
        } else {
            Supplier<Map> supplier;
            try {
                Constructor constructor = clazz.getDeclaredConstructor(new Class[0]);
                supplier = () -> {
                    try {
                        return (Map)constructor.newInstance(new Object[0]);
                    }
                    catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                        throw new CodecConfigurationException("Can not invoke no-args constructor for Map class %s", e);
                    }
                };
            }
            catch (NoSuchMethodException e) {
                supplier = () -> {
                    throw new CodecConfigurationException(String.format("Map class %s has no public no-args constructor", clazz), e);
                };
            }
            this.supplier = supplier;
        }
    }

    abstract T readValue(BsonReader var1, DecoderContext var2);

    abstract void writeValue(BsonWriter var1, T var2, EncoderContext var3);

    @Override
    public void encode(BsonWriter writer, M map2, EncoderContext encoderContext) {
        writer.writeStartDocument();
        for (Map.Entry entry : map2.entrySet()) {
            writer.writeName((String)entry.getKey());
            Object value = entry.getValue();
            if (value == null) {
                writer.writeNull();
                continue;
            }
            this.writeValue(writer, value, encoderContext);
        }
        writer.writeEndDocument();
    }

    @Override
    public M decode(BsonReader reader, DecoderContext decoderContext) {
        Map map2 = (Map)this.supplier.get();
        reader.readStartDocument();
        while (reader.readBsonType() != BsonType.END_OF_DOCUMENT) {
            String fieldName = reader.readName();
            if (reader.getCurrentBsonType() == BsonType.NULL) {
                reader.readNull();
                map2.put(fieldName, null);
                continue;
            }
            map2.put(fieldName, this.readValue(reader, decoderContext));
        }
        reader.readEndDocument();
        return (M)map2;
    }

    @Override
    public Class<M> getEncoderClass() {
        return this.clazz;
    }
}

