/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.codecs;

import com.willfp.eco.libs.bson.BsonArray;
import com.willfp.eco.libs.bson.BsonBinary;
import com.willfp.eco.libs.bson.BsonBoolean;
import com.willfp.eco.libs.bson.BsonDateTime;
import com.willfp.eco.libs.bson.BsonDbPointer;
import com.willfp.eco.libs.bson.BsonDecimal128;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonDocumentWrapper;
import com.willfp.eco.libs.bson.BsonDouble;
import com.willfp.eco.libs.bson.BsonInt32;
import com.willfp.eco.libs.bson.BsonInt64;
import com.willfp.eco.libs.bson.BsonJavaScript;
import com.willfp.eco.libs.bson.BsonJavaScriptWithScope;
import com.willfp.eco.libs.bson.BsonMaxKey;
import com.willfp.eco.libs.bson.BsonMinKey;
import com.willfp.eco.libs.bson.BsonNull;
import com.willfp.eco.libs.bson.BsonObjectId;
import com.willfp.eco.libs.bson.BsonRegularExpression;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonSymbol;
import com.willfp.eco.libs.bson.BsonTimestamp;
import com.willfp.eco.libs.bson.BsonType;
import com.willfp.eco.libs.bson.BsonUndefined;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.RawBsonDocument;
import com.willfp.eco.libs.bson.codecs.BsonArrayCodec;
import com.willfp.eco.libs.bson.codecs.BsonBinaryCodec;
import com.willfp.eco.libs.bson.codecs.BsonBooleanCodec;
import com.willfp.eco.libs.bson.codecs.BsonDBPointerCodec;
import com.willfp.eco.libs.bson.codecs.BsonDateTimeCodec;
import com.willfp.eco.libs.bson.codecs.BsonDecimal128Codec;
import com.willfp.eco.libs.bson.codecs.BsonDocumentCodec;
import com.willfp.eco.libs.bson.codecs.BsonDocumentWrapperCodec;
import com.willfp.eco.libs.bson.codecs.BsonDoubleCodec;
import com.willfp.eco.libs.bson.codecs.BsonInt32Codec;
import com.willfp.eco.libs.bson.codecs.BsonInt64Codec;
import com.willfp.eco.libs.bson.codecs.BsonJavaScriptCodec;
import com.willfp.eco.libs.bson.codecs.BsonJavaScriptWithScopeCodec;
import com.willfp.eco.libs.bson.codecs.BsonMaxKeyCodec;
import com.willfp.eco.libs.bson.codecs.BsonMinKeyCodec;
import com.willfp.eco.libs.bson.codecs.BsonNullCodec;
import com.willfp.eco.libs.bson.codecs.BsonObjectIdCodec;
import com.willfp.eco.libs.bson.codecs.BsonRegularExpressionCodec;
import com.willfp.eco.libs.bson.codecs.BsonStringCodec;
import com.willfp.eco.libs.bson.codecs.BsonSymbolCodec;
import com.willfp.eco.libs.bson.codecs.BsonTimestampCodec;
import com.willfp.eco.libs.bson.codecs.BsonTypeClassMap;
import com.willfp.eco.libs.bson.codecs.BsonUndefinedCodec;
import com.willfp.eco.libs.bson.codecs.BsonValueCodec;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.RawBsonDocumentCodec;
import com.willfp.eco.libs.bson.codecs.configuration.CodecProvider;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import java.util.HashMap;
import java.util.Map;

public class BsonValueCodecProvider
implements CodecProvider {
    private static final BsonTypeClassMap DEFAULT_BSON_TYPE_CLASS_MAP;
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();

    public BsonValueCodecProvider() {
        this.addCodecs();
    }

    public static Class<? extends BsonValue> getClassForBsonType(BsonType bsonType) {
        return DEFAULT_BSON_TYPE_CLASS_MAP.get(bsonType);
    }

    public static BsonTypeClassMap getBsonTypeClassMap() {
        return DEFAULT_BSON_TYPE_CLASS_MAP;
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonJavaScriptWithScope.class) {
            return new BsonJavaScriptWithScopeCodec(registry.get(BsonDocument.class));
        }
        if (clazz == BsonValue.class) {
            return new BsonValueCodec(registry);
        }
        if (clazz == BsonDocumentWrapper.class) {
            return new BsonDocumentWrapperCodec(registry.get(BsonDocument.class));
        }
        if (clazz == RawBsonDocument.class) {
            return new RawBsonDocumentCodec();
        }
        if (BsonDocument.class.isAssignableFrom(clazz)) {
            return new BsonDocumentCodec(registry);
        }
        if (BsonArray.class.isAssignableFrom(clazz)) {
            return new BsonArrayCodec(registry);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new BsonNullCodec());
        this.addCodec(new BsonBinaryCodec());
        this.addCodec(new BsonBooleanCodec());
        this.addCodec(new BsonDateTimeCodec());
        this.addCodec(new BsonDBPointerCodec());
        this.addCodec(new BsonDoubleCodec());
        this.addCodec(new BsonInt32Codec());
        this.addCodec(new BsonInt64Codec());
        this.addCodec(new BsonDecimal128Codec());
        this.addCodec(new BsonMinKeyCodec());
        this.addCodec(new BsonMaxKeyCodec());
        this.addCodec(new BsonJavaScriptCodec());
        this.addCodec(new BsonObjectIdCodec());
        this.addCodec(new BsonRegularExpressionCodec());
        this.addCodec(new BsonStringCodec());
        this.addCodec(new BsonSymbolCodec());
        this.addCodec(new BsonTimestampCodec());
        this.addCodec(new BsonUndefinedCodec());
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    public String toString() {
        return "BsonValueCodecProvider{}";
    }

    static {
        HashMap map2 = new HashMap();
        map2.put(BsonType.NULL, BsonNull.class);
        map2.put(BsonType.ARRAY, BsonArray.class);
        map2.put(BsonType.BINARY, BsonBinary.class);
        map2.put(BsonType.BOOLEAN, BsonBoolean.class);
        map2.put(BsonType.DATE_TIME, BsonDateTime.class);
        map2.put(BsonType.DB_POINTER, BsonDbPointer.class);
        map2.put(BsonType.DOCUMENT, BsonDocument.class);
        map2.put(BsonType.DOUBLE, BsonDouble.class);
        map2.put(BsonType.INT32, BsonInt32.class);
        map2.put(BsonType.INT64, BsonInt64.class);
        map2.put(BsonType.DECIMAL128, BsonDecimal128.class);
        map2.put(BsonType.MAX_KEY, BsonMaxKey.class);
        map2.put(BsonType.MIN_KEY, BsonMinKey.class);
        map2.put(BsonType.JAVASCRIPT, BsonJavaScript.class);
        map2.put(BsonType.JAVASCRIPT_WITH_SCOPE, BsonJavaScriptWithScope.class);
        map2.put(BsonType.OBJECT_ID, BsonObjectId.class);
        map2.put(BsonType.REGULAR_EXPRESSION, BsonRegularExpression.class);
        map2.put(BsonType.STRING, BsonString.class);
        map2.put(BsonType.SYMBOL, BsonSymbol.class);
        map2.put(BsonType.TIMESTAMP, BsonTimestamp.class);
        map2.put(BsonType.UNDEFINED, BsonUndefined.class);
        DEFAULT_BSON_TYPE_CLASS_MAP = new BsonTypeClassMap(map2);
    }
}

