/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.codecs;

import com.willfp.eco.libs.bson.BsonInvalidOperationException;
import com.willfp.eco.libs.bson.BsonReader;
import com.willfp.eco.libs.bson.BsonWriter;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.DecoderContext;
import com.willfp.eco.libs.bson.codecs.EncoderContext;
import com.willfp.eco.libs.bson.codecs.NumberCodecHelper;

public class ByteCodec
implements Codec<Byte> {
    @Override
    public void encode(BsonWriter writer, Byte value, EncoderContext encoderContext) {
        writer.writeInt32(value.byteValue());
    }

    @Override
    public Byte decode(BsonReader reader, DecoderContext decoderContext) {
        int value = NumberCodecHelper.decodeInt(reader);
        if (value < -128 || value > 127) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Byte.", value));
        }
        return (byte)value;
    }

    @Override
    public Class<Byte> getEncoderClass() {
        return Byte.class;
    }
}

