/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.codecs;

import com.willfp.eco.libs.bson.BsonInvalidOperationException;
import com.willfp.eco.libs.bson.BsonReader;
import com.willfp.eco.libs.bson.BsonType;
import com.willfp.eco.libs.bson.BsonWriter;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.DecoderContext;
import com.willfp.eco.libs.bson.codecs.EncoderContext;
import com.willfp.eco.libs.bson.codecs.RepresentationConfigurable;
import com.willfp.eco.libs.bson.codecs.configuration.CodecConfigurationException;
import com.willfp.eco.libs.bson.types.ObjectId;

public class StringCodec
implements Codec<String>,
RepresentationConfigurable<String> {
    private final BsonType representation;

    public StringCodec() {
        this.representation = BsonType.STRING;
    }

    private StringCodec(BsonType representation) {
        this.representation = representation;
    }

    @Override
    public BsonType getRepresentation() {
        return this.representation;
    }

    @Override
    public Codec<String> withRepresentation(BsonType representation) {
        if (representation != BsonType.OBJECT_ID && representation != BsonType.STRING) {
            throw new CodecConfigurationException((Object)((Object)representation) + " is not a supported representation for StringCodec");
        }
        return new StringCodec(representation);
    }

    @Override
    public void encode(BsonWriter writer, String value, EncoderContext encoderContext) {
        switch (this.representation) {
            case STRING: {
                writer.writeString(value);
                break;
            }
            case OBJECT_ID: {
                writer.writeObjectId(new ObjectId(value));
                break;
            }
            default: {
                throw new BsonInvalidOperationException("Cannot encode a String to a " + (Object)((Object)this.representation));
            }
        }
    }

    @Override
    public String decode(BsonReader reader, DecoderContext decoderContext) {
        switch (this.representation) {
            case STRING: {
                if (reader.getCurrentBsonType() == BsonType.SYMBOL) {
                    return reader.readSymbol();
                }
                return reader.readString();
            }
            case OBJECT_ID: {
                return reader.readObjectId().toHexString();
            }
        }
        throw new CodecConfigurationException("Cannot decode " + (Object)((Object)this.representation) + " to a String");
    }

    @Override
    public Class<String> getEncoderClass() {
        return String.class;
    }
}

