/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.codecs.pojo;

import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.EnumCodec;
import com.willfp.eco.libs.bson.codecs.configuration.CodecConfigurationException;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.bson.codecs.pojo.PropertyCodecProvider;
import com.willfp.eco.libs.bson.codecs.pojo.PropertyCodecRegistry;
import com.willfp.eco.libs.bson.codecs.pojo.TypeWithTypeParameters;

final class EnumPropertyCodecProvider
implements PropertyCodecProvider {
    private final CodecRegistry codecRegistry;

    EnumPropertyCodecProvider(CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    @Override
    public <T> Codec<T> get(TypeWithTypeParameters<T> type2, PropertyCodecRegistry propertyCodecRegistry) {
        Class<T> clazz = type2.getType();
        if (Enum.class.isAssignableFrom(clazz)) {
            try {
                return this.codecRegistry.get(clazz);
            }
            catch (CodecConfigurationException e) {
                return new EnumCodec<T>(clazz);
            }
        }
        return null;
    }
}

