/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.internal;

import com.willfp.eco.libs.bson.BsonArray;
import com.willfp.eco.libs.bson.BsonBinary;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonJavaScriptWithScope;
import com.willfp.eco.libs.bson.BsonValue;

public final class BsonUtil {
    public static BsonDocument mutableDeepCopy(BsonDocument original) {
        BsonDocument copy2 = new BsonDocument(original.size());
        original.forEach((key, value) -> copy2.put((String)key, BsonUtil.mutableDeepCopy(value)));
        return copy2;
    }

    private static BsonArray mutableDeepCopy(BsonArray original) {
        BsonArray copy2 = new BsonArray(original.size());
        original.forEach(element -> copy2.add(BsonUtil.mutableDeepCopy(element)));
        return copy2;
    }

    private static BsonBinary mutableDeepCopy(BsonBinary original) {
        return new BsonBinary(original.getType(), (byte[])original.getData().clone());
    }

    private static BsonJavaScriptWithScope mutableDeepCopy(BsonJavaScriptWithScope original) {
        return new BsonJavaScriptWithScope(original.getCode(), BsonUtil.mutableDeepCopy(original.getScope()));
    }

    private static BsonValue mutableDeepCopy(BsonValue original) {
        switch (original.getBsonType()) {
            case DOCUMENT: {
                return BsonUtil.mutableDeepCopy(original.asDocument());
            }
            case ARRAY: {
                return BsonUtil.mutableDeepCopy(original.asArray());
            }
            case BINARY: {
                return BsonUtil.mutableDeepCopy(original.asBinary());
            }
            case JAVASCRIPT_WITH_SCOPE: {
                return BsonUtil.mutableDeepCopy(original.asJavaScriptWithScope());
            }
        }
        return original;
    }

    private BsonUtil() {
    }
}

