/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.json;

import com.willfp.eco.libs.bson.json.Converter;
import com.willfp.eco.libs.bson.json.ExtendedJsonDoubleConverter;
import com.willfp.eco.libs.bson.json.StrictJsonWriter;

class RelaxedExtendedJsonDoubleConverter
implements Converter<Double> {
    private static final Converter<Double> FALLBACK_CONVERTER = new ExtendedJsonDoubleConverter();

    RelaxedExtendedJsonDoubleConverter() {
    }

    @Override
    public void convert(Double value, StrictJsonWriter writer) {
        if (value.isNaN() || value.isInfinite()) {
            FALLBACK_CONVERTER.convert(value, writer);
        } else {
            writer.writeNumber(Double.toString(value));
        }
    }
}

