/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.types;

import com.willfp.eco.libs.bson.BSONObject;
import com.willfp.eco.libs.bson.types.StringRangeSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class BasicBSONList
extends ArrayList<Object>
implements BSONObject {
    private static final long serialVersionUID = -4415279469780082174L;

    @Override
    public Object put(String key, Object v) {
        return this.put(this._getInt(key), v);
    }

    public Object put(int key, Object value) {
        while (key >= this.size()) {
            this.add(null);
        }
        this.set(key, value);
        return value;
    }

    @Override
    public void putAll(Map m4) {
        for (Map.Entry entry : m4.entrySet()) {
            this.put(entry.getKey().toString(), entry.getValue());
        }
    }

    @Override
    public void putAll(BSONObject o) {
        for (String k : o.keySet()) {
            this.put(k, o.get(k));
        }
    }

    @Override
    public Object get(String key) {
        int i = this._getInt(key);
        if (i < 0) {
            return null;
        }
        if (i >= this.size()) {
            return null;
        }
        return this.get(i);
    }

    @Override
    public Object removeField(String key) {
        int i = this._getInt(key);
        if (i < 0) {
            return null;
        }
        if (i >= this.size()) {
            return null;
        }
        return this.remove(i);
    }

    @Override
    public boolean containsField(String key) {
        int i = this._getInt(key, false);
        if (i < 0) {
            return false;
        }
        return i >= 0 && i < this.size();
    }

    @Override
    public Set<String> keySet() {
        return new StringRangeSet(this.size());
    }

    @Override
    public Map toMap() {
        HashMap<String, Object> m4 = new HashMap<String, Object>();
        for (String s2 : this.keySet()) {
            m4.put(s2, this.get(String.valueOf(s2)));
        }
        return m4;
    }

    int _getInt(String s2) {
        return this._getInt(s2, true);
    }

    int _getInt(String s2, boolean err) {
        try {
            return Integer.parseInt(s2);
        }
        catch (Exception e) {
            if (err) {
                throw new IllegalArgumentException("BasicBSONList can only work with numeric keys, not: [" + s2 + "]");
            }
            return -1;
        }
    }
}

