/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson.types;

import com.willfp.eco.libs.bson.BsonBinarySubType;
import java.io.Serializable;
import java.util.Arrays;

public class Binary
implements Serializable {
    private static final long serialVersionUID = 7902997490338209467L;
    private final byte type;
    private final byte[] data;

    public Binary(byte[] data2) {
        this(BsonBinarySubType.BINARY, data2);
    }

    public Binary(BsonBinarySubType type2, byte[] data2) {
        this(type2.getValue(), data2);
    }

    public Binary(byte type2, byte[] data2) {
        this.type = type2;
        this.data = (byte[])data2.clone();
    }

    public byte getType() {
        return this.type;
    }

    public byte[] getData() {
        return (byte[])this.data.clone();
    }

    public int length() {
        return this.data.length;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binary binary = (Binary)o;
        if (this.type != binary.type) {
            return false;
        }
        return Arrays.equals(this.data, binary.data);
    }

    public int hashCode() {
        int result2 = this.type;
        result2 = 31 * result2 + Arrays.hashCode(this.data);
        return result2;
    }
}

