/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson4jackson.deserializers;

import com.willfp.eco.libs.bson4jackson.BsonParser;
import com.willfp.eco.libs.jackson.core.JsonParser;
import com.willfp.eco.libs.jackson.core.JsonToken;
import com.willfp.eco.libs.jackson.databind.DeserializationContext;
import com.willfp.eco.libs.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Date;

public class BsonDateDeserializer
extends JsonDeserializer<Date> {
    @Override
    public Date deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp instanceof BsonParser) {
            BsonParser bsonParser = (BsonParser)jp;
            if (bsonParser.getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || bsonParser.getCurrentBsonType() != 9) {
                throw ctxt.mappingException(Date.class);
            }
            return (Date)bsonParser.getEmbeddedObject();
        }
        if (jp.getCurrentToken() == JsonToken.VALUE_EMBEDDED_OBJECT && jp.getEmbeddedObject() instanceof Date) {
            return (Date)jp.getEmbeddedObject();
        }
        return new Date(jp.getLongValue());
    }
}

