/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson4jackson.deserializers;

import com.willfp.eco.libs.bson4jackson.BsonParser;
import com.willfp.eco.libs.jackson.core.JsonParser;
import com.willfp.eco.libs.jackson.core.JsonToken;
import com.willfp.eco.libs.jackson.core.TreeNode;
import com.willfp.eco.libs.jackson.databind.DeserializationContext;
import com.willfp.eco.libs.jackson.databind.JsonDeserializer;
import com.willfp.eco.libs.jackson.databind.node.ValueNode;
import java.io.IOException;
import java.util.regex.Pattern;

public class BsonRegexDeserializer
extends JsonDeserializer<Pattern> {
    @Override
    public Pattern deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        if (jp instanceof BsonParser) {
            BsonParser bsonParser = (BsonParser)jp;
            if (bsonParser.getCurrentToken() != JsonToken.VALUE_EMBEDDED_OBJECT || bsonParser.getCurrentBsonType() != 11) {
                throw ctxt.mappingException(Pattern.class);
            }
            return (Pattern)bsonParser.getEmbeddedObject();
        }
        if (jp.getCurrentToken() == JsonToken.VALUE_EMBEDDED_OBJECT && jp.getEmbeddedObject() instanceof Pattern) {
            return (Pattern)jp.getEmbeddedObject();
        }
        Object tree = jp.getCodec().readTree(jp);
        TreeNode patternNode = tree.get("$pattern");
        String pattern = ((ValueNode)patternNode).asText();
        TreeNode flagsNode = tree.get("$flags");
        int flags = ((ValueNode)flagsNode).asInt();
        return Pattern.compile(pattern, flags);
    }
}

