/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson4jackson.io;

import com.willfp.eco.libs.bson4jackson.io.StaticBuffers;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class StaticBufferedInputStream
extends InputStream {
    protected static final StaticBuffers.Key BUFFER_KEY = StaticBuffers.Key.BUFFER1;
    protected final StaticBuffers _staticBuffers;
    protected final ByteBuffer _byteBuffer;
    protected final byte[] _raw;
    protected final InputStream _in;
    protected int _pos;
    protected int _count;
    protected int _mark = -1;

    public StaticBufferedInputStream(InputStream in) {
        this(in, 8192);
    }

    public StaticBufferedInputStream(InputStream in, int size) {
        this._in = in;
        this._staticBuffers = StaticBuffers.getInstance();
        this._byteBuffer = this._staticBuffers.byteBuffer(BUFFER_KEY, size);
        this._raw = this._byteBuffer.array();
    }

    @Override
    public void close() throws IOException {
        this._staticBuffers.releaseByteBuffer(BUFFER_KEY, this._byteBuffer);
        super.close();
    }

    protected void fill() throws IOException {
        if (this._mark < 0) {
            this._pos = 0;
        } else if (this._pos >= this._raw.length) {
            if (this._mark > 0) {
                int cnt = this._pos - this._mark;
                System.arraycopy(this._raw, this._mark, this._raw, 0, cnt);
                this._pos = cnt;
                this._mark = 0;
            } else {
                this._mark = -1;
                this._pos = 0;
            }
        }
        this._count = this._pos;
        int n = this._in.read(this._raw, this._pos, this._raw.length - this._pos);
        if (n > 0) {
            this._count += n;
        }
    }

    @Override
    public int read() throws IOException {
        if (this._pos >= this._count) {
            this.fill();
            if (this._pos >= this._count) {
                return -1;
            }
        }
        return this._raw[this._pos++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (len == 0) {
            return 0;
        }
        int read2 = 0;
        while (len > 0) {
            int avail = this._count - this._pos;
            if (avail <= 0) {
                this.fill();
                avail = this._count - this._pos;
                if (avail <= 0) {
                    return read2 == 0 ? -1 : read2;
                }
            }
            int cnt = Math.min(avail, len);
            System.arraycopy(this._raw, this._pos, b, off, cnt);
            off += cnt;
            this._pos += cnt;
            read2 += cnt;
            len -= cnt;
        }
        return read2;
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        long avail = this._count - this._pos;
        if (avail <= 0L) {
            return this._in.skip(n);
        }
        long cnt = Math.min(avail, n);
        this._pos = (int)((long)this._pos + cnt);
        return cnt;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int marklimit) {
        this._mark = this._pos;
    }

    @Override
    public void reset() throws IOException {
        if (this._mark < 0) {
            throw new IOException("Invalid mark");
        }
        this._pos = this._mark;
    }
}

