/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.bson4jackson.io;

import java.lang.ref.SoftReference;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;

public class StaticBuffers {
    public static final int GLOBAL_MIN_SIZE = 65536;
    protected static final ThreadLocal<SoftReference<StaticBuffers>> _instance = new ThreadLocal();
    protected ByteBuffer[] _byteBuffers = new ByteBuffer[Key.values().length];
    protected CharBuffer[] _charBuffers = new CharBuffer[Key.values().length];

    protected StaticBuffers() {
    }

    public static StaticBuffers getInstance() {
        StaticBuffers buf;
        SoftReference<StaticBuffers> ref = _instance.get();
        StaticBuffers staticBuffers = buf = ref == null ? null : ref.get();
        if (buf == null) {
            buf = new StaticBuffers();
            _instance.set(new SoftReference<StaticBuffers>(buf));
        }
        return buf;
    }

    public CharBuffer charBuffer(Key key, int minSize) {
        minSize = Math.max(minSize, 65536);
        CharBuffer r = this._charBuffers[key.ordinal()];
        if (r == null || r.capacity() < minSize) {
            r = CharBuffer.allocate(minSize);
        } else {
            this._charBuffers[key.ordinal()] = null;
            r.clear();
        }
        return r;
    }

    public void releaseCharBuffer(Key key, CharBuffer buf) {
        this._charBuffers[key.ordinal()] = buf;
    }

    public ByteBuffer byteBuffer(Key key, int minSize) {
        minSize = Math.max(minSize, 65536);
        ByteBuffer r = this._byteBuffers[key.ordinal()];
        if (r == null || r.capacity() < minSize) {
            r = ByteBuffer.allocate(minSize);
        } else {
            this._byteBuffers[key.ordinal()] = null;
            r.clear();
        }
        return r;
    }

    public void releaseByteBuffer(Key key, ByteBuffer buf) {
        this._byteBuffers[key.ordinal()] = buf;
    }

    public static enum Key {
        BUFFER0,
        BUFFER1,
        BUFFER2,
        BUFFER3,
        BUFFER4,
        BUFFER5,
        BUFFER6,
        BUFFER7,
        BUFFER8,
        BUFFER9;

    }
}

