/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.crunch;

import com.willfp.eco.libs.crunch.Variable;
import com.willfp.eco.libs.crunch.exceptions.ExpressionEvaluationException;
import com.willfp.eco.libs.crunch.token.Operation;
import com.willfp.eco.libs.crunch.token.TokenType;
import com.willfp.eco.libs.crunch.token.Value;

public class CompiledExpression {
    protected double[] variableValues;
    private int variableCount;
    private Value value;

    protected CompiledExpression() {
    }

    protected void setVariableValues(double[] values2) {
        this.checkArgCount(values2.length);
        this.variableValues = values2;
    }

    protected void setValue(Value value) {
        this.value = value;
        this.variableCount = this.recursiveVariableMaxIndex(value) + 1;
    }

    private int recursiveVariableMaxIndex(Value value) {
        if (value.getType() == TokenType.VARIABLE) {
            Variable var = (Variable)value;
            var.expression = this;
            return var.getIndex();
        }
        if (value.getType() != TokenType.OPERATION) {
            return -1;
        }
        int count2 = -1;
        Operation operation = (Operation)value;
        for (Value val : operation.getValues()) {
            if (val.getType() == TokenType.VARIABLE) {
                Variable var = (Variable)val;
                var.expression = this;
                count2 = Math.max(count2, var.getIndex());
            }
            if (val.getType() != TokenType.OPERATION) continue;
            count2 = Math.max(count2, this.recursiveVariableMaxIndex(val));
        }
        return count2;
    }

    protected Value getValue() {
        return this.value;
    }

    public int getVariableCount() {
        return this.variableCount;
    }

    public double evaluate(double ... values2) {
        this.setVariableValues(values2);
        return this.value.getValue();
    }

    public double evaluate() {
        this.checkArgCount(0);
        return this.value.getValue();
    }

    public double evaluate(double first2) {
        this.checkArgCount(1);
        if (this.variableValues == null) {
            this.variableValues = new double[1];
        }
        this.variableValues[0] = first2;
        return this.value.getValue();
    }

    public double evaluate(double first2, double second2) {
        this.checkArgCount(2);
        if (this.variableValues == null) {
            this.variableValues = new double[2];
        }
        this.variableValues[0] = first2;
        this.variableValues[1] = second2;
        return this.value.getValue();
    }

    private void checkArgCount(int args2) {
        if (this.variableCount > args2) {
            throw new ExpressionEvaluationException("Too few variable values - expected " + this.variableCount + ", got " + args2);
        }
    }

    public CompiledExpression clone() {
        CompiledExpression clone = new CompiledExpression();
        Value cloned = this.value.getClone();
        clone.setValue(cloned);
        return clone;
    }

    public String toString() {
        return this.value.toString();
    }
}

