/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.crunch.data;

import com.willfp.eco.libs.crunch.data.Pair;

public class CharTree<T> {
    private Node root = new Node();

    public void set(String str, T value) {
        Node node = this.root;
        for (char c : str.toCharArray()) {
            node = node.getOrCreateNode(c);
        }
        node.setValue(value);
    }

    public T get(String str) {
        Node node = this.root;
        for (char c : str.toCharArray()) {
            if ((node = node.getNode(c)) != null) continue;
            return null;
        }
        return (T)node.getValue();
    }

    public boolean containsFirstChar(char c) {
        return this.root.getNode(c) != null;
    }

    public Pair<T, Integer> getFrom(String str, int index) {
        Node node = this.root;
        Object val = null;
        for (int i = index; i < str.length(); ++i) {
            if ((node = node.getNode(str.charAt(i))) == null) {
                return new Pair<Object, Integer>(val, i - index);
            }
            if (node.getValue() == null) continue;
            val = node.getValue();
        }
        return new Pair<Object, Integer>(val, str.length() - index);
    }

    private static class Node {
        private Object value;
        private Node[] children = new Node[256];

        private Node() {
        }

        public Node getNode(char c) {
            return this.children[c];
        }

        public Node getOrCreateNode(char c) {
            if (this.children[c] == null) {
                this.children[c] = new Node();
            }
            return this.children[c];
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

