/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.crunch.functional;

import com.willfp.eco.libs.crunch.Variable;
import com.willfp.eco.libs.crunch.data.CharTree;
import com.willfp.eco.libs.crunch.functional.Function;
import com.willfp.eco.libs.crunch.token.Constant;
import com.willfp.eco.libs.crunch.token.LazyVariable;
import com.willfp.eco.libs.crunch.token.Operator;
import com.willfp.eco.libs.crunch.token.Token;
import java.util.Locale;
import java.util.function.DoubleSupplier;
import java.util.function.ToDoubleFunction;

public class EvaluationEnvironment {
    private CharTree<Token> namedTokens = new CharTree();

    public EvaluationEnvironment() {
        for (Operator operator : Operator.values()) {
            if (operator.isInternal()) continue;
            this.namedTokens.set(operator.getSymbol(), operator);
        }
        for (Enum enum_ : Constant.values()) {
            this.namedTokens.set(((Constant)enum_).toString().toLowerCase(Locale.ROOT), (Token)((Object)enum_));
        }
    }

    public void addFunction(Function function) {
        char[] chars;
        for (char c : chars = function.getName().toCharArray()) {
            if (c <= '\u00ff') continue;
            throw new IllegalArgumentException("Function names must be ASCII only");
        }
        this.namedTokens.set(function.getName(), function);
    }

    public void addFunctions(Function ... functions2) {
        for (Function function : functions2) {
            this.addFunction(function);
        }
    }

    public void addLazyVariable(String name, DoubleSupplier supply) {
        this.namedTokens.set(name, new LazyVariable(name, supply));
    }

    public void setVariableNames(String ... names) {
        for (int i = 0; i < names.length; ++i) {
            this.namedTokens.set(names[i], new Variable(null, i));
        }
    }

    public void addFunction(String name, int argCount, ToDoubleFunction<double[]> func) {
        this.addFunction(new Function(name, argCount, func));
    }

    public void clearFunctions() {
        this.namedTokens = new CharTree();
    }

    public CharTree<Token> getNamedTokens() {
        return this.namedTokens;
    }
}

