/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.jackson.databind.ser.std;

import com.willfp.eco.libs.jackson.core.JsonGenerator;
import com.willfp.eco.libs.jackson.core.JsonToken;
import com.willfp.eco.libs.jackson.core.type.WritableTypeId;
import com.willfp.eco.libs.jackson.databind.JavaType;
import com.willfp.eco.libs.jackson.databind.JsonMappingException;
import com.willfp.eco.libs.jackson.databind.JsonNode;
import com.willfp.eco.libs.jackson.databind.SerializerProvider;
import com.willfp.eco.libs.jackson.databind.annotation.JacksonStdImpl;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonArrayFormatVisitor;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonFormatTypes;
import com.willfp.eco.libs.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import com.willfp.eco.libs.jackson.databind.jsontype.TypeSerializer;
import com.willfp.eco.libs.jackson.databind.node.ObjectNode;
import com.willfp.eco.libs.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Type;

@JacksonStdImpl
public class ByteArraySerializer
extends StdSerializer<byte[]> {
    private static final long serialVersionUID = 1L;

    public ByteArraySerializer() {
        super(byte[].class);
    }

    @Override
    public boolean isEmpty(SerializerProvider prov, byte[] value) {
        return value.length == 0;
    }

    @Override
    public void serialize(byte[] value, JsonGenerator g2, SerializerProvider provider) throws IOException {
        g2.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
    }

    @Override
    public void serializeWithType(byte[] value, JsonGenerator g2, SerializerProvider provider, TypeSerializer typeSer) throws IOException {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g2, typeSer.typeId(value, JsonToken.VALUE_EMBEDDED_OBJECT));
        g2.writeBinary(provider.getConfig().getBase64Variant(), value, 0, value.length);
        typeSer.writeTypeSuffix(g2, typeIdDef);
    }

    @Override
    @Deprecated
    public JsonNode getSchema(SerializerProvider provider, Type typeHint) {
        ObjectNode o = this.createSchemaNode("array", true);
        ObjectNode itemSchema = this.createSchemaNode("byte");
        return o.set("items", itemSchema);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor2, JavaType typeHint) throws JsonMappingException {
        JsonArrayFormatVisitor v2 = visitor2.expectArrayFormat(typeHint);
        if (v2 != null) {
            v2.itemsFormat(JsonFormatTypes.INTEGER);
        }
    }
}

