/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.lang3.concurrent;

import com.willfp.eco.libs.lang3.Validate;
import com.willfp.eco.libs.lang3.concurrent.BackgroundInitializer;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;

public class CallableBackgroundInitializer<T>
extends BackgroundInitializer<T> {
    private final Callable<T> callable;

    public CallableBackgroundInitializer(Callable<T> call) {
        this.checkCallable(call);
        this.callable = call;
    }

    public CallableBackgroundInitializer(Callable<T> call, ExecutorService exec2) {
        super(exec2);
        this.checkCallable(call);
        this.callable = call;
    }

    @Override
    protected T initialize() throws Exception {
        return this.callable.call();
    }

    private void checkCallable(Callable<T> call) {
        Validate.isTrue(call != null, "Callable must not be null!", new Object[0]);
    }
}

