/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.litote.kmongo.jackson;

import com.willfp.eco.libs.bson.BsonTimestamp;
import com.willfp.eco.libs.bson.types.Binary;
import com.willfp.eco.libs.bson4jackson.BsonFactory;
import com.willfp.eco.libs.bson4jackson.BsonGenerator;
import com.willfp.eco.libs.bson4jackson.BsonParser;
import com.willfp.eco.libs.bson4jackson.io.ByteOrderUtil;
import com.willfp.eco.libs.bson4jackson.types.ObjectId;
import com.willfp.eco.libs.bson4jackson.types.Timestamp;
import com.willfp.eco.libs.jackson.core.JsonEncoding;
import com.willfp.eco.libs.jackson.core.ObjectCodec;
import com.willfp.eco.libs.jackson.core.io.IOContext;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.libs.litote.kmongo.jackson.BsonModule;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00102\u00020\u0001:\u0003\u0010\u0011\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\b\u0010\t\u001a\u00020\u0001H\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/KMongoBsonFactory;", "Lcom/willfp/eco/libs/bson4jackson/BsonFactory;", "()V", "_createParser", "Lcom/willfp/eco/libs/bson4jackson/BsonParser;", "inputStream", "Ljava/io/InputStream;", "ctxt", "Lcom/willfp/eco/libs/jackson/core/io/IOContext;", "copy", "createGenerator", "Lcom/willfp/eco/libs/bson4jackson/BsonGenerator;", "outputStream", "Ljava/io/OutputStream;", "enc", "Lcom/willfp/eco/libs/jackson/core/JsonEncoding;", "Companion", "KMongoBsonGenerator", "KMongoBsonParser", "kmongo-jackson-mapping"})
public final class KMongoBsonFactory
extends BsonFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int OBJECT_ID_LENGTH = 12;

    public KMongoBsonFactory() {
        this.enable(BsonParser.Feature.HONOR_DOCUMENT_LENGTH);
        this.enable(BsonGenerator.Feature.WRITE_BIGDECIMALS_AS_DECIMAL128);
    }

    @Override
    @NotNull
    public BsonGenerator createGenerator(@NotNull OutputStream outputStream, @NotNull JsonEncoding enc) {
        Intrinsics.checkNotNullParameter(outputStream, "outputStream");
        Intrinsics.checkNotNullParameter((Object)enc, "enc");
        OutputStream out = outputStream;
        IOContext ctxt = this._createContext(out, true);
        ctxt.setEncoding(enc);
        if (enc == JsonEncoding.UTF8 && this._outputDecorator != null) {
            OutputStream outputStream2 = this._outputDecorator.decorate(ctxt, out);
            Intrinsics.checkNotNullExpressionValue(outputStream2, "_outputDecorator.decorate(ctxt, out)");
            out = outputStream2;
        }
        KMongoBsonGenerator g2 = new KMongoBsonGenerator(this._generatorFeatures, this._bsonGeneratorFeatures, out);
        ObjectCodec codec = this.getCodec();
        if (codec != null) {
            g2.setCodec(codec);
        }
        if (this._characterEscapes != null) {
            g2.setCharacterEscapes(this._characterEscapes);
        }
        return g2;
    }

    @Override
    @NotNull
    protected BsonParser _createParser(@NotNull InputStream inputStream, @NotNull IOContext ctxt) {
        Intrinsics.checkNotNullParameter(inputStream, "inputStream");
        Intrinsics.checkNotNullParameter(ctxt, "ctxt");
        KMongoBsonParser p = new KMongoBsonParser(ctxt, this._parserFeatures, this._bsonParserFeatures, inputStream);
        ObjectCodec codec = this.getCodec();
        if (codec != null) {
            p.setCodec(codec);
        }
        return p;
    }

    @Override
    @NotNull
    public BsonFactory copy() {
        return new KMongoBsonFactory();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0005\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\u0004J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\r\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/KMongoBsonFactory$Companion;", "", "()V", "OBJECT_ID_LENGTH", "", "createFromLegacyFormat", "Lcom/willfp/eco/libs/bson/types/ObjectId;", "time", "machine", "inc", "int0", "", "x", "int1", "int2", "int3", "legacyToBytes", "", "timestamp", "machineAndProcessIdentifier", "counter", "kmongo-jackson-mapping"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final com.willfp.eco.libs.bson.types.ObjectId createFromLegacyFormat(int time, int machine, int inc) {
            return new com.willfp.eco.libs.bson.types.ObjectId(this.legacyToBytes(time, machine, inc));
        }

        private final byte[] legacyToBytes(int timestamp, int machineAndProcessIdentifier, int counter) {
            byte[] bytes = new byte[]{this.int3(timestamp), this.int2(timestamp), this.int1(timestamp), this.int0(timestamp), this.int3(machineAndProcessIdentifier), this.int2(machineAndProcessIdentifier), this.int1(machineAndProcessIdentifier), this.int0(machineAndProcessIdentifier), this.int3(counter), this.int2(counter), this.int1(counter), this.int0(counter)};
            return bytes;
        }

        private final byte int3(int x) {
            return (byte)(x >> 24);
        }

        private final byte int2(int x) {
            return (byte)(x >> 16);
        }

        private final byte int1(int x) {
            return (byte)(x >> 8);
        }

        private final byte int0(int x) {
            return (byte)x;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u000bJ\u0006\u0010\u0012\u001a\u00020\u000bJ\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0012\u0010\u0016\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0015H\u0016\u00a8\u0006\u0018"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/KMongoBsonFactory$KMongoBsonGenerator;", "Lcom/willfp/eco/libs/bson4jackson/BsonGenerator;", "jsonFeatures", "", "bsonFeatures", "out", "Ljava/io/OutputStream;", "(IILjava/io/OutputStream;)V", "canWriteObjectId", "", "writeBinary", "", "binary", "Lcom/willfp/eco/libs/bson/types/Binary;", "writeBsonTimestamp", "timestamp", "Lcom/willfp/eco/libs/bson/BsonTimestamp;", "writeMaxKey", "writeMinKey", "writeObjectId", "objectId", "", "writeObjectRef", "id", "kmongo-jackson-mapping"})
    @SourceDebugExtension(value={"SMAP\nKMongoBsonFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KMongoBsonFactory.kt\norg/litote/kmongo/jackson/KMongoBsonFactory$KMongoBsonGenerator\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,219:1\n13586#2,2:220\n*S KotlinDebug\n*F\n+ 1 KMongoBsonFactory.kt\norg/litote/kmongo/jackson/KMongoBsonFactory$KMongoBsonGenerator\n*L\n60#1:220,2\n*E\n"})
    public static final class KMongoBsonGenerator
    extends BsonGenerator {
        public KMongoBsonGenerator(int jsonFeatures, int bsonFeatures, @NotNull OutputStream out) {
            Intrinsics.checkNotNullParameter(out, "out");
            super(jsonFeatures, bsonFeatures, out);
        }

        @Override
        public boolean canWriteObjectId() {
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void writeObjectId(@NotNull Object objectId) {
            Intrinsics.checkNotNullParameter(objectId, "objectId");
            if (!(objectId instanceof com.willfp.eco.libs.bson.types.ObjectId)) {
                if (!(objectId instanceof String)) throw new IllegalStateException((objectId + " has to be " + Reflection.getOrCreateKotlinClass(com.willfp.eco.libs.bson.types.ObjectId.class)).toString());
                this.writeFieldName("_id");
                this.writeString((String)objectId);
                return;
            } else {
                this._writeArrayFieldNameIfNeeded();
                this._verifyValueWrite("write object id");
                this._buffer.putByte(this._typeMarker, (byte)7);
                byte[] byArray = ((com.willfp.eco.libs.bson.types.ObjectId)objectId).toByteArray();
                Intrinsics.checkNotNullExpressionValue(byArray, "objectId.toByteArray()");
                byte[] $this$forEach$iv = byArray;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    byte element$iv;
                    byte it = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    this._buffer.putByte(it);
                }
                this.flushBuffer();
            }
        }

        @Override
        public void writeObjectRef(@Nullable Object id2) {
            if (id2 instanceof String) {
                this.writeString((String)id2);
            } else {
                super.writeObjectRef(id2);
            }
        }

        public final void writeBinary(@NotNull Binary binary) {
            Intrinsics.checkNotNullParameter(binary, "binary");
            this._writeArrayFieldNameIfNeeded();
            this._verifyValueWrite("write binary");
            byte[] bytes = binary.getData();
            this._buffer.putByte(this._typeMarker, (byte)5);
            this._buffer.putInt(bytes.length);
            this._buffer.putByte(binary.getType());
            byte[] byArray = binary.getData();
            this._buffer.putBytes(Arrays.copyOf(byArray, byArray.length));
            this.flushBuffer();
        }

        public final void writeBsonTimestamp(@NotNull BsonTimestamp timestamp) {
            Intrinsics.checkNotNullParameter(timestamp, "timestamp");
            this._writeArrayFieldNameIfNeeded();
            this._verifyValueWrite("write timestamp");
            this._buffer.putByte(this._typeMarker, (byte)17);
            this._buffer.putInt(timestamp.getInc());
            this._buffer.putInt(timestamp.getTime());
            this.flushBuffer();
        }

        public final void writeMinKey() {
            this._writeArrayFieldNameIfNeeded();
            this._verifyValueWrite("write min key");
            this._buffer.putByte(this._typeMarker, (byte)-1);
            this.flushBuffer();
        }

        public final void writeMaxKey() {
            this._writeArrayFieldNameIfNeeded();
            this._verifyValueWrite("write max key");
            this._buffer.putByte(this._typeMarker, (byte)127);
            this.flushBuffer();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u0011H\u0014\u00a8\u0006\u0014"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/jackson/KMongoBsonFactory$KMongoBsonParser;", "Lcom/willfp/eco/libs/bson4jackson/BsonParser;", "ctxt", "Lcom/willfp/eco/libs/jackson/core/io/IOContext;", "jsonFeatures", "", "bsonFeatures", "inputStream", "Ljava/io/InputStream;", "(Lcom/fasterxml/jackson/core/io/IOContext;IILjava/io/InputStream;)V", "convertToBSONTimestamp", "", "ts", "Lcom/willfp/eco/libs/bson4jackson/types/Timestamp;", "convertToNativeObjectId", "Lcom/willfp/eco/libs/bson/types/ObjectId;", "id", "Lcom/willfp/eco/libs/bson4jackson/types/ObjectId;", "getEmbeddedObject", "readObjectId", "kmongo-jackson-mapping"})
    private static final class KMongoBsonParser
    extends BsonParser {
        public KMongoBsonParser(@NotNull IOContext ctxt, int jsonFeatures, int bsonFeatures, @NotNull InputStream inputStream) {
            Intrinsics.checkNotNullParameter(ctxt, "ctxt");
            Intrinsics.checkNotNullParameter(inputStream, "inputStream");
            super(ctxt, jsonFeatures, bsonFeatures, inputStream);
        }

        @Override
        @NotNull
        public Object getEmbeddedObject() {
            Object embedded = super.getEmbeddedObject();
            if (embedded instanceof ObjectId) {
                return this.convertToNativeObjectId((ObjectId)embedded);
            }
            if (embedded instanceof Timestamp) {
                return this.convertToBSONTimestamp((Timestamp)embedded);
            }
            Intrinsics.checkNotNullExpressionValue(embedded, "embedded");
            return embedded;
        }

        private final Object convertToBSONTimestamp(Timestamp ts) {
            return new BsonTimestamp(ts.getTime(), ts.getInc());
        }

        private final com.willfp.eco.libs.bson.types.ObjectId convertToNativeObjectId(ObjectId id2) {
            return Companion.createFromLegacyFormat(id2.getTime(), id2.getMachine(), id2.getInc());
        }

        @Override
        @NotNull
        protected ObjectId readObjectId() {
            int time = ByteOrderUtil.flip(this._in.readInt());
            int machine = ByteOrderUtil.flip(this._in.readInt());
            int inc = ByteOrderUtil.flip(this._in.readInt());
            return new BsonModule.KMongoObjectId(time, machine, inc);
        }
    }
}

