/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.litote.kmongo.util;

import com.willfp.eco.libs.bson.BsonArray;
import com.willfp.eco.libs.bson.BsonBoolean;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonDocumentWriter;
import com.willfp.eco.libs.bson.BsonDouble;
import com.willfp.eco.libs.bson.BsonInt32;
import com.willfp.eco.libs.bson.BsonInt64;
import com.willfp.eco.libs.bson.BsonObjectId;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.Document;
import com.willfp.eco.libs.bson.codecs.BsonArrayCodec;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.DecoderContext;
import com.willfp.eco.libs.bson.codecs.Encoder;
import com.willfp.eco.libs.bson.codecs.EncoderContext;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.bson.json.JsonReader;
import com.willfp.eco.libs.bson.types.ObjectId;
import com.willfp.eco.libs.jetbrains.annotations.NotNull;
import com.willfp.eco.libs.jetbrains.annotations.Nullable;
import com.willfp.eco.libs.litote.kmongo.Id;
import com.willfp.eco.libs.litote.kmongo.MongoOperator;
import com.willfp.eco.libs.litote.kmongo.id.IdGenerator;
import com.willfp.eco.libs.litote.kmongo.id.StringId;
import com.willfp.eco.libs.litote.kmongo.id.WrappedObjectId;
import com.willfp.eco.libs.litote.kmongo.service.ClassMappingType;
import com.willfp.eco.libs.litote.kmongo.util.CollectionNameFormatter;
import com.willfp.eco.libs.litote.kmongo.util.KMongoUtil;
import com.willfp.eco.libs.litote.kmongo.util.ObjectMappingConfiguration;
import com.willfp.eco.libs.litote.kmongo.util.SimpleExpression;
import com.willfp.eco.libs.mongodb.client.model.BsonField;
import com.willfp.eco.libs.mongodb.client.model.DeleteManyModel;
import com.willfp.eco.libs.mongodb.client.model.DeleteOneModel;
import com.willfp.eco.libs.mongodb.client.model.Filters;
import com.willfp.eco.libs.mongodb.client.model.InsertOneModel;
import com.willfp.eco.libs.mongodb.client.model.ReplaceOneModel;
import com.willfp.eco.libs.mongodb.client.model.ReplaceOptions;
import com.willfp.eco.libs.mongodb.client.model.UpdateManyModel;
import com.willfp.eco.libs.mongodb.client.model.UpdateOneModel;
import com.willfp.eco.libs.mongodb.client.model.UpdateOptions;
import com.willfp.eco.libs.mongodb.client.model.WriteModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.text.StringsKt;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0014\u001a\u00020\u00152\u000e\u0010\u0016\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0017H\u0002J\u0012\u0010\u0018\u001a\u00020\u00042\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aJ/\u0010\u001b\u001a\u00020\u001c\"\b\b\u0000\u0010\u001d*\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u0001H\u001d2\u0006\u0010!\u001a\u00020\f\u00a2\u0006\u0002\u0010\"J\u001a\u0010#\u001a\u00020\u00012\u0006\u0010$\u001a\u00020\u00012\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aJ\u0018\u0010%\u001a\u00020&2\u0006\u0010$\u001a\u00020\u00012\b\b\u0002\u0010'\u001a\u00020\u0015J\u000e\u0010(\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004J(\u0010*\u001a\u00020&\"\b\b\u0000\u0010+*\u00020\u00012\u0006\u0010,\u001a\u00020&2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H+0\u001aH\u0002J\u0016\u0010.\u001a\u00020\u00012\u000e\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u001aJ\u0012\u00100\u001a\u0004\u0018\u0001012\b\u00102\u001a\u0004\u0018\u00010\u0001J\u0010\u00103\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020\u0001J\u000e\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u0001J\u0010\u00107\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u0004H\u0002J\u0018\u00108\u001a\u0002052\u0006\u0010$\u001a\u00020\u00012\b\b\u0002\u00109\u001a\u00020\u0015J\u000e\u0010:\u001a\u00020&2\u0006\u0010)\u001a\u00020\u0004J&\u0010:\u001a\u00020&\"\b\b\u0000\u0010+*\u00020\u00012\u0006\u0010)\u001a\u00020\u00042\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H+0\u001aJ)\u0010;\u001a\b\u0012\u0004\u0012\u0002050\n2\u000e\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040<2\u0006\u0010!\u001a\u00020\f\u00a2\u0006\u0002\u0010=J\u0018\u0010>\u001a\u0002052\u0006\u0010$\u001a\u00020\u00012\b\b\u0002\u00109\u001a\u00020\u0015J\u000e\u0010?\u001a\u00020\u00042\u0006\u0010$\u001a\u00020\u0001JG\u0010@\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0A0\n\"\b\b\u0000\u0010+*\u00020\u00012\u000e\u0010)\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00040<2\u0006\u0010!\u001a\u00020\f2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H+0\u001a\u00a2\u0006\u0002\u0010BJ.\u0010@\u001a\b\u0012\u0004\u0012\u00020&0A\"\b\b\u0000\u0010+*\u00020\u00012\u0006\u0010C\u001a\u00020&2\f\u0010-\u001a\b\u0012\u0004\u0012\u0002H+0\u001aH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\n \u0006*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u0011\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0010\u001a\u0004\b\u0012\u0010\u000e\u00a8\u0006D"}, d2={"Lcom/willfp/eco/libs/litote/kmongo/util/KMongoUtil;", "", "()V", "EMPTY_JSON", "", "QUOTE_REPLACE_MATCHER", "kotlin.jvm.PlatformType", "SPACE_REPLACE_PATTERN", "Ljava/util/regex/Pattern;", "UPDATE_OPERATORS", "", "defaultCodecRegistry", "Lcom/willfp/eco/libs/bson/codecs/configuration/CodecRegistry;", "getDefaultCodecRegistry", "()Lorg/bson/codecs/configuration/CodecRegistry;", "defaultCodecRegistry$delegate", "Lkotlin/Lazy;", "internalDefaultRegistry", "getInternalDefaultRegistry", "internalDefaultRegistry$delegate", "containsUpdateOperator", "", "map", "", "defaultCollectionName", "clazz", "Lkotlin/reflect/KClass;", "encodeValue", "", "TItem", "writer", "Lcom/willfp/eco/libs/bson/BsonDocumentWriter;", "value", "codecRegistry", "(Lorg/bson/BsonDocumentWriter;Ljava/lang/Object;Lorg/bson/codecs/configuration/CodecRegistry;)V", "extractId", "obj", "filterIdToBson", "Lcom/willfp/eco/libs/bson/BsonDocument;", "filterNullProperties", "formatJson", "json", "generateIfAbsentAndMayBeMoveId", "T", "document", "type", "generateNewIdForIdClass", "idClass", "getIdBsonValue", "Lcom/willfp/eco/libs/bson/BsonValue;", "idValue", "getIdValue", "idFilterQuery", "Lcom/willfp/eco/libs/bson/conversions/Bson;", "id", "isJsonArray", "setModifier", "updateOnlyNotNullProperties", "toBson", "toBsonList", "", "([Ljava/lang/String;Lorg/bson/codecs/configuration/CodecRegistry;)Ljava/util/List;", "toBsonModifier", "toExtendedJson", "toWriteModel", "Lcom/willfp/eco/libs/mongodb/client/model/WriteModel;", "([Ljava/lang/String;Lorg/bson/codecs/configuration/CodecRegistry;Lkotlin/reflect/KClass;)Ljava/util/List;", "bson", "kmongo-shared"})
@SourceDebugExtension(value={"SMAP\nKMongoUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KMongoUtil.kt\norg/litote/kmongo/util/KMongoUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,334:1\n1549#2:335\n1620#2,3:336\n1747#2,3:343\n1549#2:346\n1620#2,3:347\n1549#2:354\n1620#2,3:355\n11335#3:339\n11670#3,3:340\n11335#3:350\n11670#3,3:351\n*S KotlinDebug\n*F\n+ 1 KMongoUtil.kt\norg/litote/kmongo/util/KMongoUtil\n*L\n175#1:335\n175#1:336,3\n204#1:343,3\n243#1:346\n243#1:347,3\n104#1:354\n104#1:355,3\n177#1:339\n177#1:340,3\n245#1:350\n245#1:351,3\n*E\n"})
public final class KMongoUtil {
    @NotNull
    public static final KMongoUtil INSTANCE;
    @NotNull
    public static final String EMPTY_JSON = "{}";
    private static final Pattern SPACE_REPLACE_PATTERN;
    private static final String QUOTE_REPLACE_MATCHER;
    @NotNull
    private static final List<String> UPDATE_OPERATORS;
    @NotNull
    private static final Lazy internalDefaultRegistry$delegate;
    @NotNull
    private static final Lazy defaultCodecRegistry$delegate;

    private KMongoUtil() {
    }

    private final CodecRegistry getInternalDefaultRegistry() {
        Lazy lazy = internalDefaultRegistry$delegate;
        return (CodecRegistry)lazy.getValue();
    }

    @NotNull
    public final CodecRegistry getDefaultCodecRegistry() {
        Lazy lazy = defaultCodecRegistry$delegate;
        Object t2 = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue(t2, "<get-defaultCodecRegistry>(...)");
        return (CodecRegistry)t2;
    }

    @NotNull
    public final Object generateNewIdForIdClass(@NotNull KClass<? extends Object> idClass) {
        Id id2;
        Intrinsics.checkNotNullParameter(idClass, "idClass");
        if (Intrinsics.areEqual(idClass, Reflection.getOrCreateKotlinClass(ObjectId.class))) {
            id2 = ObjectId.get();
        } else if (Intrinsics.areEqual(idClass, Reflection.getOrCreateKotlinClass(String.class))) {
            id2 = ObjectId.get().toString();
        } else if (Intrinsics.areEqual(idClass, Reflection.getOrCreateKotlinClass(WrappedObjectId.class))) {
            ObjectId objectId = ObjectId.get();
            Intrinsics.checkNotNullExpressionValue(objectId, "get()");
            id2 = new WrappedObjectId(objectId);
        } else if (Intrinsics.areEqual(idClass, Reflection.getOrCreateKotlinClass(StringId.class))) {
            String string = ObjectId.get().toString();
            Intrinsics.checkNotNullExpressionValue(string, "get().toString()");
            id2 = new StringId(string);
        } else if (KClasses.isSubclassOf(idClass, Reflection.getOrCreateKotlinClass(Id.class))) {
            id2 = IdGenerator.Companion.getDefaultGenerator().generateNewId();
        } else {
            throw new IllegalStateException(("generation for id property type not supported : " + idClass).toString());
        }
        ObjectId objectId = id2;
        Intrinsics.checkNotNullExpressionValue(objectId, "when {\n            idCla\u2026)\n            }\n        }");
        return objectId;
    }

    @NotNull
    public final BsonDocument toBson(@NotNull String json) {
        BsonDocument bsonDocument;
        Intrinsics.checkNotNullParameter(json, "json");
        if (Intrinsics.areEqual(json, EMPTY_JSON)) {
            bsonDocument = new BsonDocument();
        } else {
            BsonDocument bsonDocument2 = BsonDocument.parse(json);
            bsonDocument = bsonDocument2;
            Intrinsics.checkNotNullExpressionValue(bsonDocument2, "parse(json)");
        }
        return bsonDocument;
    }

    @NotNull
    public final <T> BsonDocument toBson(@NotNull String json, @NotNull KClass<T> type2) {
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(type2, "type");
        return this.generateIfAbsentAndMayBeMoveId(this.toBson(json), type2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final <T> BsonDocument generateIfAbsentAndMayBeMoveId(BsonDocument document2, KClass<T> type2) {
        KProperty1<?, ?> idProperty;
        if (document2.containsKey("_id") || (idProperty = ClassMappingType.INSTANCE.findIdProperty(type2)) == null) return document2;
        BsonValue idValue = (BsonValue)document2.get(idProperty.getName());
        if (idValue == null) {
            String toString2 = idProperty.getReturnType().toString();
            String string = Reflection.getOrCreateKotlinClass(ObjectId.class).getQualifiedName();
            Intrinsics.checkNotNull(string);
            if (StringsKt.startsWith$default(toString2, string, false, 2, null)) {
                document2.put("_id", new BsonObjectId(ObjectId.get()));
            } else {
                String string2 = Reflection.getOrCreateKotlinClass(String.class).getQualifiedName();
                Intrinsics.checkNotNull(string2);
                if (!StringsKt.startsWith$default(toString2, string2, false, 2, null)) throw new IllegalStateException(("generation for id property type not supported : " + idProperty).toString());
                document2.put("_id", new BsonString(ObjectId.get().toString()));
            }
        } else {
            document2.put("_id", idValue);
        }
        if (Intrinsics.areEqual(idProperty.getName(), "_id")) return document2;
        document2.remove(idProperty.getName());
        return document2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Bson> toBsonList(@NotNull String[] json, @NotNull CodecRegistry codecRegistry) {
        List list;
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(codecRegistry, "codecRegistry");
        if (json.length == 1 && this.isJsonArray(json[0])) {
            void $this$mapTo$iv$iv;
            BsonArray bsonArray = new BsonArrayCodec(codecRegistry).decode(new JsonReader(json[0]), DecoderContext.builder().build());
            Intrinsics.checkNotNullExpressionValue(bsonArray, "BsonArrayCodec(codecRegi\u2026ontext.builder().build())");
            Iterable $this$map$iv = bsonArray;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BsonValue bsonValue = (BsonValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.bson.BsonDocument");
                collection.add((BsonDocument)it);
            }
            list = (List)destination$iv$iv;
        } else {
            String[] $this$map$iv = json;
            boolean $i$f$map = false;
            String[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = $this$mapTo$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                void it;
                String item$iv$iv;
                String bl = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(INSTANCE.toBson((String)it));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    @NotNull
    public final BsonDocument filterIdToBson(@NotNull Object obj, boolean filterNullProperties) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        return ClassMappingType.INSTANCE.filterIdToBson(obj, filterNullProperties);
    }

    public static /* synthetic */ BsonDocument filterIdToBson$default(KMongoUtil kMongoUtil, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = !ObjectMappingConfiguration.INSTANCE.getSerializeNull();
        }
        return kMongoUtil.filterIdToBson(object, bl);
    }

    @NotNull
    public final String formatJson(@NotNull String json) {
        Intrinsics.checkNotNullParameter(json, "json");
        String string = SPACE_REPLACE_PATTERN.matcher(json).replaceAll(QUOTE_REPLACE_MATCHER);
        Intrinsics.checkNotNullExpressionValue(string, "SPACE_REPLACE_PATTERN.ma\u2026ll(QUOTE_REPLACE_MATCHER)");
        return string;
    }

    @NotNull
    public final String toExtendedJson(@NotNull Object obj) {
        String string;
        Intrinsics.checkNotNullParameter(obj, "obj");
        if (obj instanceof Bson) {
            String string2 = ((Bson)obj).toBsonDocument(Document.class, this.getInternalDefaultRegistry()).toJson();
            Intrinsics.checkNotNullExpressionValue(string2, "{\n            obj.toBson\u2026     ).toJson()\n        }");
            string = string2;
        } else {
            string = ClassMappingType.INSTANCE.toExtendedJson(obj);
        }
        return string;
    }

    private final boolean isJsonArray(String json) {
        return StringsKt.startsWith$default((CharSequence)((Object)StringsKt.trim((CharSequence)json)).toString(), '[', false, 2, null);
    }

    @NotNull
    public final Bson idFilterQuery(@NotNull Object id2) {
        Intrinsics.checkNotNullParameter(id2, "id");
        Bson bson = Filters.eq("_id", id2);
        Intrinsics.checkNotNullExpressionValue(bson, "eq(\"_id\", id)");
        return bson;
    }

    private final boolean containsUpdateOperator(Map<?, ?> map2) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = UPDATE_OPERATORS;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!map2.containsKey(it)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public final Bson toBsonModifier(@NotNull Object obj, boolean updateOnlyNotNullProperties) {
        Bson bson;
        Intrinsics.checkNotNullParameter(obj, "obj");
        Object object = obj;
        if (object instanceof Bson) {
            bson = (Bson)obj;
        } else {
            if (object instanceof BsonField) {
                throw new IllegalStateException(("BsonField must be used only for " + (Object)((Object)MongoOperator.group) + " operations").toString());
            }
            bson = object instanceof String ? (Bson)this.toBson((String)obj) : this.setModifier(obj, updateOnlyNotNullProperties);
        }
        return bson;
    }

    public static /* synthetic */ Bson toBsonModifier$default(KMongoUtil kMongoUtil, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kMongoUtil.toBsonModifier(object, bl);
    }

    @NotNull
    public final Bson setModifier(@NotNull Object obj, boolean updateOnlyNotNullProperties) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        return obj instanceof Map && this.containsUpdateOperator((Map)obj) ? (Bson)this.toBson(this.toExtendedJson(obj)) : (Bson)new SimpleExpression<BsonDocument>(String.valueOf((Object)MongoOperator.set), this.filterIdToBson(obj, updateOnlyNotNullProperties));
    }

    public static /* synthetic */ Bson setModifier$default(KMongoUtil kMongoUtil, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return kMongoUtil.setModifier(object, bl);
    }

    @NotNull
    public final Object extractId(@NotNull Object obj, @NotNull KClass<?> clazz) {
        Intrinsics.checkNotNullParameter(obj, "obj");
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        if (obj instanceof Map) {
            Object v = ((Map)obj).get("_id");
            if (v == null) {
                throw new IllegalStateException("_id is null".toString());
            }
            return v;
        }
        KProperty1<?, ?> idProperty = ClassMappingType.INSTANCE.findIdProperty(clazz);
        if (idProperty == null) {
            throw new IllegalArgumentException(obj + " has to contain _id field");
        }
        Object obj2 = ClassMappingType.INSTANCE.getIdValue(idProperty, obj);
        if (obj2 == null) {
            throw new IllegalStateException("id is null".toString());
        }
        return obj2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <T> List<WriteModel<BsonDocument>> toWriteModel(@NotNull String[] json, @NotNull CodecRegistry codecRegistry, @NotNull KClass<T> type2) {
        List list;
        Intrinsics.checkNotNullParameter(json, "json");
        Intrinsics.checkNotNullParameter(codecRegistry, "codecRegistry");
        Intrinsics.checkNotNullParameter(type2, "type");
        if (json.length == 1 && this.isJsonArray(json[0])) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            BsonArray bsonArray = new BsonArrayCodec(codecRegistry).decode(new JsonReader(json[0]), DecoderContext.builder().build());
            Intrinsics.checkNotNullExpressionValue(bsonArray, "BsonArrayCodec(codecRegi\u2026ontext.builder().build())");
            Iterable iterable = bsonArray;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                BsonValue bsonValue = (BsonValue)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull(it, "null cannot be cast to non-null type org.bson.BsonDocument");
                collection.add(INSTANCE.toWriteModel((BsonDocument)it, type2));
            }
            list = (List)destination$iv$iv;
        } else {
            String[] $this$map$iv = json;
            boolean $i$f$map = false;
            String[] $this$mapTo$iv$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = $this$mapTo$iv$iv.length;
            for (int i = 0; i < n; ++i) {
                void it;
                String item$iv$iv;
                String bl = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(INSTANCE.toWriteModel(INSTANCE.toBson((String)it), type2));
            }
            list = (List)destination$iv$iv;
        }
        return list;
    }

    private final <T> WriteModel<BsonDocument> toWriteModel(BsonDocument bson, KClass<T> type2) {
        if (bson.containsKey("insertOne")) {
            BsonDocument bsonDocument = bson.getDocument("insertOne");
            Intrinsics.checkNotNullExpressionValue(bsonDocument, "bson.getDocument(\"insertOne\")");
            return new InsertOneModel<BsonDocument>(this.generateIfAbsentAndMayBeMoveId(bsonDocument, type2));
        }
        if (bson.containsKey("updateOne")) {
            BsonDocument updateOne2 = bson.getDocument("updateOne");
            return new UpdateOneModel((Bson)updateOne2.getDocument("filter"), updateOne2.getDocument("update"), new UpdateOptions().upsert(updateOne2.getBoolean("upsert", BsonBoolean.FALSE).getValue()));
        }
        if (bson.containsKey("updateMany")) {
            BsonDocument updateMany2 = bson.getDocument("updateMany");
            return new UpdateManyModel((Bson)updateMany2.getDocument("filter"), updateMany2.getDocument("update"), new UpdateOptions().upsert(updateMany2.getBoolean("upsert", BsonBoolean.FALSE).getValue()));
        }
        if (bson.containsKey("replaceOne")) {
            BsonDocument replaceOne2 = bson.getDocument("replaceOne");
            return new ReplaceOneModel<BsonDocument>(replaceOne2.getDocument("filter"), replaceOne2.getDocument("replacement"), new ReplaceOptions().upsert(replaceOne2.getBoolean("upsert", BsonBoolean.FALSE).getValue()));
        }
        if (bson.containsKey("deleteOne")) {
            BsonDocument deleteOne2 = bson.getDocument("deleteOne");
            return new DeleteOneModel(deleteOne2.getDocument("filter"));
        }
        if (bson.containsKey("deleteMany")) {
            BsonDocument deleteMany2 = bson.getDocument("deleteMany");
            return new DeleteManyModel(deleteMany2.getDocument("filter"));
        }
        throw new IllegalArgumentException("unknown write model : " + bson);
    }

    @NotNull
    public final String defaultCollectionName(@NotNull KClass<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        return CollectionNameFormatter.INSTANCE.getDefaultCollectionNameBuilder().invoke(clazz);
    }

    @Nullable
    public final Object getIdValue(@NotNull Object value) {
        Intrinsics.checkNotNullParameter(value, "value");
        if (value instanceof Map) {
            return ((Map)value).get("_id");
        }
        KProperty1<?, ?> idProperty = ClassMappingType.INSTANCE.findIdProperty(JvmClassMappingKt.getKotlinClass(value.getClass()));
        return idProperty == null ? null : ClassMappingType.INSTANCE.getIdValue(idProperty, value);
    }

    public final <TItem> void encodeValue(@NotNull BsonDocumentWriter writer, @Nullable TItem value, @NotNull CodecRegistry codecRegistry) {
        Intrinsics.checkNotNullParameter(writer, "writer");
        Intrinsics.checkNotNullParameter(codecRegistry, "codecRegistry");
        TItem TItem = value;
        if (TItem == null) {
            writer.writeNull();
        } else if (TItem instanceof Bson) {
            Codec<BsonDocument> codec = codecRegistry.get(BsonDocument.class);
            Intrinsics.checkNotNull(codec, "null cannot be cast to non-null type org.bson.codecs.Encoder<kotlin.Any>");
            ((Encoder)codec).encode(writer, ((Bson)value).toBsonDocument(BsonDocument.class, codecRegistry), EncoderContext.builder().build());
        } else {
            Class<?> clazz = value.getClass();
            Intrinsics.checkNotNull(clazz, "null cannot be cast to non-null type java.lang.Class<TItem of org.litote.kmongo.util.KMongoUtil.encodeValue>");
            Codec<?> codec = codecRegistry.get(clazz);
            Intrinsics.checkNotNull(codec, "null cannot be cast to non-null type org.bson.codecs.Encoder<TItem of org.litote.kmongo.util.KMongoUtil.encodeValue>");
            ((Encoder)codec).encode(writer, value, EncoderContext.builder().build());
        }
    }

    @Nullable
    public final BsonValue getIdBsonValue(@Nullable Object idValue) {
        Object object = idValue;
        return object == null ? null : (object instanceof ObjectId ? (BsonValue)new BsonObjectId((ObjectId)idValue) : (object instanceof String ? (BsonValue)new BsonString((String)idValue) : (object instanceof Double ? (BsonValue)new BsonDouble(((Number)idValue).doubleValue()) : (object instanceof Integer ? (BsonValue)new BsonInt32(((Number)idValue).intValue()) : (object instanceof Long ? (BsonValue)new BsonInt64(((Number)idValue).longValue()) : (BsonValue)this.toBson(this.toExtendedJson(idValue)))))));
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_3;
        void $this$mapTo$iv$iv;
        INSTANCE = new KMongoUtil();
        SPACE_REPLACE_PATTERN = Pattern.compile("\\$\\s+");
        QUOTE_REPLACE_MATCHER = Matcher.quoteReplacement("$");
        MongoOperator[] mongoOperatorArray = new MongoOperator[]{MongoOperator.inc, MongoOperator.mul, MongoOperator.rename, MongoOperator.setOnInsert, MongoOperator.set, MongoOperator.unset, MongoOperator.min, MongoOperator.max, MongoOperator.currentDate, MongoOperator.addToSet, MongoOperator.pop, MongoOperator.pull, MongoOperator.push, MongoOperator.pullAll, MongoOperator.bit};
        Iterable $this$map$iv = CollectionsKt.listOf(mongoOperatorArray);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            MongoOperator mongoOperator = (MongoOperator)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.toString());
        }
        UPDATE_OPERATORS = (List)var3_3;
        internalDefaultRegistry$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, (Function0)internalDefaultRegistry.2.INSTANCE);
        defaultCodecRegistry$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, (Function0)defaultCodecRegistry.2.INSTANCE);
    }
}

