/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.client.model;

import com.willfp.eco.libs.bson.BsonArray;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.Document;
import com.willfp.eco.libs.bson.assertions.Assertions;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.mongodb.client.model.BsonField;
import com.willfp.eco.libs.mongodb.client.model.QuantileMethod;
import com.willfp.eco.libs.mongodb.client.model.SimpleExpression;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.List;
import java.util.stream.Collectors;

public final class Accumulators {
    public static <TExpression> BsonField sum(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$sum", fieldName, expression);
    }

    public static <TExpression> BsonField avg(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$avg", fieldName, expression);
    }

    public static <InExpression, PExpression> BsonField percentile(String fieldName, InExpression inExpression, PExpression pExpression, QuantileMethod method) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("inExpression", inExpression);
        Assertions.notNull("pExpression", inExpression);
        Assertions.notNull("method", method);
        return Accumulators.quantileAccumulator("$percentile", fieldName, inExpression, pExpression, method);
    }

    public static <InExpression> BsonField median(String fieldName, InExpression inExpression, QuantileMethod method) {
        Assertions.notNull("fieldName", fieldName);
        Assertions.notNull("inExpression", inExpression);
        Assertions.notNull("method", method);
        return Accumulators.quantileAccumulator("$median", fieldName, inExpression, null, method);
    }

    public static <TExpression> BsonField first(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$first", fieldName, expression);
    }

    public static <InExpression, NExpression> BsonField firstN(String fieldName, InExpression inExpression, NExpression nExpression) {
        return Accumulators.pickNAccumulator(Assertions.notNull("fieldName", fieldName), "$firstN", Assertions.notNull("inExpression", inExpression), Assertions.notNull("nExpression", nExpression));
    }

    public static <OutExpression> BsonField top(String fieldName, Bson sortBy2, OutExpression outExpression) {
        return Accumulators.sortingPickAccumulator(Assertions.notNull("fieldName", fieldName), "$top", Assertions.notNull("sortBy", sortBy2), Assertions.notNull("outExpression", outExpression));
    }

    public static <OutExpression, NExpression> BsonField topN(String fieldName, Bson sortBy2, OutExpression outExpression, NExpression nExpression) {
        return Accumulators.sortingPickNAccumulator(Assertions.notNull("fieldName", fieldName), "$topN", Assertions.notNull("sortBy", sortBy2), Assertions.notNull("outExpression", outExpression), Assertions.notNull("nExpression", nExpression));
    }

    public static <TExpression> BsonField last(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$last", fieldName, expression);
    }

    public static <InExpression, NExpression> BsonField lastN(String fieldName, InExpression inExpression, NExpression nExpression) {
        return Accumulators.pickNAccumulator(Assertions.notNull("fieldName", fieldName), "$lastN", Assertions.notNull("inExpression", inExpression), Assertions.notNull("nExpression", nExpression));
    }

    public static <OutExpression> BsonField bottom(String fieldName, Bson sortBy2, OutExpression outExpression) {
        return Accumulators.sortingPickAccumulator(Assertions.notNull("fieldName", fieldName), "$bottom", Assertions.notNull("sortBy", sortBy2), Assertions.notNull("outExpression", outExpression));
    }

    public static <OutExpression, NExpression> BsonField bottomN(String fieldName, Bson sortBy2, OutExpression outExpression, NExpression nExpression) {
        return Accumulators.sortingPickNAccumulator(Assertions.notNull("fieldName", fieldName), "$bottomN", Assertions.notNull("sortBy", sortBy2), Assertions.notNull("outExpression", outExpression), Assertions.notNull("nExpression", nExpression));
    }

    public static <TExpression> BsonField max(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$max", fieldName, expression);
    }

    public static <InExpression, NExpression> BsonField maxN(String fieldName, InExpression inExpression, NExpression nExpression) {
        return Accumulators.pickNAccumulator(Assertions.notNull("fieldName", fieldName), "$maxN", Assertions.notNull("inExpression", inExpression), Assertions.notNull("nExpression", nExpression));
    }

    public static <TExpression> BsonField min(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$min", fieldName, expression);
    }

    public static <InExpression, NExpression> BsonField minN(String fieldName, InExpression inExpression, NExpression nExpression) {
        return Accumulators.pickNAccumulator(Assertions.notNull("fieldName", fieldName), "$minN", Assertions.notNull("inExpression", inExpression), Assertions.notNull("nExpression", nExpression));
    }

    public static <TExpression> BsonField push(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$push", fieldName, expression);
    }

    public static <TExpression> BsonField addToSet(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$addToSet", fieldName, expression);
    }

    public static <TExpression> BsonField mergeObjects(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$mergeObjects", fieldName, expression);
    }

    public static <TExpression> BsonField stdDevPop(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$stdDevPop", fieldName, expression);
    }

    public static <TExpression> BsonField stdDevSamp(String fieldName, TExpression expression) {
        return Accumulators.accumulatorOperator("$stdDevSamp", fieldName, expression);
    }

    public static BsonField accumulator(String fieldName, String initFunction, String accumulateFunction, String mergeFunction) {
        return Accumulators.accumulator(fieldName, initFunction, null, accumulateFunction, null, mergeFunction, null, "js");
    }

    public static BsonField accumulator(String fieldName, String initFunction, String accumulateFunction, String mergeFunction, @Nullable String finalizeFunction) {
        return Accumulators.accumulator(fieldName, initFunction, null, accumulateFunction, null, mergeFunction, finalizeFunction, "js");
    }

    public static BsonField accumulator(String fieldName, String initFunction, @Nullable List<String> initArgs, String accumulateFunction, @Nullable List<String> accumulateArgs, String mergeFunction, @Nullable String finalizeFunction) {
        return Accumulators.accumulator(fieldName, initFunction, initArgs, accumulateFunction, accumulateArgs, mergeFunction, finalizeFunction, "js");
    }

    public static BsonField accumulator(String fieldName, String initFunction, String accumulateFunction, String mergeFunction, @Nullable String finalizeFunction, String lang) {
        return Accumulators.accumulator(fieldName, initFunction, null, accumulateFunction, null, mergeFunction, finalizeFunction, lang);
    }

    public static BsonField accumulator(String fieldName, String initFunction, @Nullable List<String> initArgs, String accumulateFunction, @Nullable List<String> accumulateArgs, String mergeFunction, @Nullable String finalizeFunction, String lang) {
        BsonDocument accumulatorStage = new BsonDocument("init", new BsonString(initFunction)).append("initArgs", initArgs != null ? new BsonArray(initArgs.stream().map(initArg -> new BsonString((String)initArg)).collect(Collectors.toList())) : new BsonArray()).append("accumulate", new BsonString(accumulateFunction)).append("accumulateArgs", accumulateArgs != null ? new BsonArray(accumulateArgs.stream().map(accumulateArg -> new BsonString((String)accumulateArg)).collect(Collectors.toList())) : new BsonArray()).append("merge", new BsonString(mergeFunction)).append("lang", new BsonString(lang));
        if (finalizeFunction != null) {
            accumulatorStage.append("finalize", new BsonString(finalizeFunction));
        }
        return Accumulators.accumulatorOperator("$accumulator", fieldName, accumulatorStage);
    }

    private static <TExpression> BsonField accumulatorOperator(String name, String fieldName, TExpression expression) {
        return new BsonField(fieldName, new SimpleExpression<TExpression>(name, expression));
    }

    private static <InExpression, NExpression> BsonField pickNAccumulator(String fieldName, String accumulatorName, InExpression inExpression, NExpression nExpression) {
        return new BsonField(fieldName, new Document(accumulatorName, new Document("input", inExpression).append("n", nExpression)));
    }

    private static <OutExpression> BsonField sortingPickAccumulator(String fieldName, String accumulatorName, Bson sort, OutExpression outExpression) {
        return new BsonField(fieldName, new Document(accumulatorName, new Document("sortBy", sort).append("output", outExpression)));
    }

    private static <OutExpression, NExpression> BsonField sortingPickNAccumulator(String fieldName, String accumulatorName, Bson sort, OutExpression outExpression, NExpression nExpression) {
        return new BsonField(fieldName, new Document(accumulatorName, new Document("sortBy", sort).append("output", outExpression).append("n", nExpression)));
    }

    private static <InExpression, PExpression> BsonField quantileAccumulator(String quantileAccumulatorName, String fieldName, InExpression inExpression, @Nullable PExpression pExpression, QuantileMethod method) {
        Document document2 = new Document("input", inExpression).append("method", method.toBsonValue());
        if (pExpression != null) {
            document2.append("p", pExpression);
        }
        return Accumulators.accumulatorOperator(quantileAccumulatorName, fieldName, document2);
    }

    private Accumulators() {
    }
}

