/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.client.model;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonDocumentWriter;
import com.willfp.eco.libs.bson.assertions.Assertions;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.bson.types.Decimal128;
import com.willfp.eco.libs.mongodb.client.model.BuildersHelper;
import com.willfp.eco.libs.mongodb.client.model.MongoTimeUnit;
import com.willfp.eco.libs.mongodb.client.model.Window;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.Objects;

public final class Windows {
    public static Window of(Bson window) {
        return new BsonWindow(Assertions.notNull("window", window));
    }

    public static Window documents(int lower, int upper) {
        com.willfp.eco.libs.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", lower <= upper);
        return new SimpleWindow<Integer, Integer>("documents", lower, upper, null);
    }

    public static Window documents(Bound lower, int upper) {
        Assertions.notNull("lower", lower);
        if (lower == Bound.CURRENT) {
            com.willfp.eco.libs.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", upper >= 0);
        }
        return new SimpleWindow<String, Integer>("documents", lower.value(), upper, null);
    }

    public static Window documents(int lower, Bound upper) {
        Assertions.notNull("upper", upper);
        if (upper == Bound.CURRENT) {
            com.willfp.eco.libs.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", lower <= 0);
        }
        return new SimpleWindow<Integer, String>("documents", lower, upper.value(), null);
    }

    public static Window documents(Bound lower, Bound upper) {
        Assertions.notNull("lower", lower);
        Assertions.notNull("upper", upper);
        return new SimpleWindow<String, String>("documents", lower.value(), upper.value(), null);
    }

    public static Window range(long lower, long upper) {
        com.willfp.eco.libs.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", lower <= upper);
        return new SimpleWindow<Long, Long>("range", lower, upper, null);
    }

    public static Window range(double lower, double upper) {
        com.willfp.eco.libs.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", lower <= upper);
        return new SimpleWindow<Double, Double>("range", lower, upper, null);
    }

    public static Window range(Decimal128 lower, Decimal128 upper) {
        Assertions.notNull("lower", lower);
        Assertions.notNull("upper", upper);
        com.willfp.eco.libs.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", lower.compareTo(upper) <= 0);
        return new SimpleWindow<Decimal128, Decimal128>("range", lower, upper, null);
    }

    public static Window range(Bound lower, long upper) {
        Assertions.notNull("lower", lower);
        return new SimpleWindow<String, Long>("range", lower.value(), upper, null);
    }

    public static Window range(Bound lower, double upper) {
        Assertions.notNull("lower", lower);
        return new SimpleWindow<String, Double>("range", lower.value(), upper, null);
    }

    public static Window range(Bound lower, Decimal128 upper) {
        Assertions.notNull("lower", lower);
        Assertions.notNull("upper", upper);
        return new SimpleWindow<String, Decimal128>("range", lower.value(), upper, null);
    }

    public static Window range(long lower, Bound upper) {
        Assertions.notNull("upper", upper);
        return new SimpleWindow<Long, String>("range", lower, upper.value(), null);
    }

    public static Window range(double lower, Bound upper) {
        Assertions.notNull("upper", upper);
        return new SimpleWindow<Double, String>("range", lower, upper.value(), null);
    }

    public static Window range(Decimal128 lower, Bound upper) {
        Assertions.notNull("lower", lower);
        Assertions.notNull("upper", upper);
        return new SimpleWindow<Decimal128, String>("range", lower, upper.value(), null);
    }

    public static Window timeRange(long lower, long upper, MongoTimeUnit unit) {
        Assertions.notNull("unit", unit);
        com.willfp.eco.libs.mongodb.assertions.Assertions.isTrueArgument("lower <= upper", lower <= upper);
        return new SimpleWindow<Long, Long>("range", lower, upper, unit);
    }

    public static Window timeRange(Bound lower, long upper, MongoTimeUnit unit) {
        Assertions.notNull("lower", lower);
        Assertions.notNull("unit", unit);
        return new SimpleWindow<String, Long>("range", lower.value(), upper, unit);
    }

    public static Window timeRange(long lower, MongoTimeUnit unit, Bound upper) {
        Assertions.notNull("unit", unit);
        Assertions.notNull("upper", upper);
        return new SimpleWindow<Long, String>("range", lower, upper.value(), unit);
    }

    private Windows() {
        throw new UnsupportedOperationException();
    }

    private static final class BsonWindow
    implements Window {
        private final Bson wrapped;

        BsonWindow(Bson document2) {
            this.wrapped = com.willfp.eco.libs.mongodb.assertions.Assertions.assertNotNull(document2);
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            return this.wrapped.toBsonDocument(tDocumentClass, codecRegistry);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BsonWindow that = (BsonWindow)o;
            return this.wrapped.equals(that.wrapped);
        }

        public int hashCode() {
            return Objects.hash(this.wrapped);
        }

        public String toString() {
            return this.wrapped.toString();
        }
    }

    private static class SimpleWindow<L, U>
    implements Window {
        static final String TYPE_POSITION_BASED = "documents";
        static final String TYPE_RANGE_BASED = "range";
        private final String type;
        private final L lower;
        private final U upper;
        @Nullable
        private final MongoTimeUnit unit;

        SimpleWindow(String type2, L lower, U upper, @Nullable MongoTimeUnit unit) {
            this.lower = lower;
            this.upper = upper;
            this.type = type2;
            this.unit = unit;
        }

        @Override
        public <TDocument> BsonDocument toBsonDocument(Class<TDocument> tDocumentClass, CodecRegistry codecRegistry) {
            BsonDocumentWriter writer = new BsonDocumentWriter(new BsonDocument());
            writer.writeStartDocument();
            writer.writeStartArray(this.type);
            BuildersHelper.encodeValue(writer, this.lower, codecRegistry);
            BuildersHelper.encodeValue(writer, this.upper, codecRegistry);
            writer.writeEndArray();
            if (this.unit != null) {
                writer.writeString("unit", this.unit.value());
            }
            writer.writeEndDocument();
            return writer.getDocument();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SimpleWindow that = (SimpleWindow)o;
            return this.type.equals(that.type) && this.lower.equals(that.lower) && this.upper.equals(that.upper) && this.unit == that.unit;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.lower, this.upper, this.unit});
        }

        public String toString() {
            return "Window{type=" + this.type + ", lower=" + this.lower + ", upper=" + this.upper + ", unit=" + (Object)((Object)this.unit) + '}';
        }
    }

    public static enum Bound {
        CURRENT("current"),
        UNBOUNDED("unbounded");

        private final String value;

        private Bound(String value) {
            this.value = value;
        }

        String value() {
            return this.value;
        }
    }
}

