/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.client.model.search;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.conversions.Bson;
import com.willfp.eco.libs.mongodb.annotations.Beta;
import com.willfp.eco.libs.mongodb.annotations.Sealed;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.client.model.search.SearchConstructibleBson;
import com.willfp.eco.libs.mongodb.client.model.search.SearchPath;
import com.willfp.eco.libs.mongodb.internal.Iterables;
import com.willfp.eco.libs.mongodb.internal.client.model.Util;
import java.util.Iterator;

@Sealed
@Beta(value={Beta.Reason.CLIENT})
public interface SearchHighlight
extends Bson {
    public SearchHighlight maxCharsToExamine(int var1);

    public SearchHighlight maxNumPassages(int var1);

    public static SearchHighlight paths(SearchPath path, SearchPath ... paths) {
        return SearchHighlight.paths(Iterables.concat(Assertions.notNull("path", path), paths));
    }

    public static SearchHighlight paths(Iterable<? extends SearchPath> paths) {
        Iterator<? extends SearchPath> pathIterator = Assertions.notNull("paths", paths).iterator();
        Assertions.isTrueArgument("paths must not be empty", pathIterator.hasNext());
        return new SearchConstructibleBson(new BsonDocument("path", Util.combineToBsonValue(pathIterator, false)));
    }

    public static SearchHighlight of(Bson highlight) {
        return new SearchConstructibleBson(Assertions.notNull("highlight", highlight));
    }
}

