/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.client.result;

import com.willfp.eco.libs.bson.BsonValue;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class InsertManyResult {
    public abstract boolean wasAcknowledged();

    public abstract Map<Integer, BsonValue> getInsertedIds();

    public static InsertManyResult acknowledged(Map<Integer, BsonValue> insertedIds) {
        return new AcknowledgedInsertManyResult(insertedIds);
    }

    public static InsertManyResult unacknowledged() {
        return new UnacknowledgedInsertManyResult();
    }

    private static class AcknowledgedInsertManyResult
    extends InsertManyResult {
        private final Map<Integer, BsonValue> insertedIds;

        AcknowledgedInsertManyResult(Map<Integer, BsonValue> insertedIds) {
            this.insertedIds = Collections.unmodifiableMap(new HashMap<Integer, BsonValue>(insertedIds));
        }

        @Override
        public boolean wasAcknowledged() {
            return true;
        }

        @Override
        public Map<Integer, BsonValue> getInsertedIds() {
            return this.insertedIds;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AcknowledgedInsertManyResult that = (AcknowledgedInsertManyResult)o;
            return Objects.equals(this.insertedIds, that.insertedIds);
        }

        public int hashCode() {
            return Objects.hash(this.insertedIds);
        }

        public String toString() {
            return "AcknowledgedInsertManyResult{insertedIds=" + this.insertedIds + '}';
        }
    }

    private static class UnacknowledgedInsertManyResult
    extends InsertManyResult {
        private UnacknowledgedInsertManyResult() {
        }

        @Override
        public boolean wasAcknowledged() {
            return false;
        }

        @Override
        public Map<Integer, BsonValue> getInsertedIds() {
            throw new UnsupportedOperationException("Cannot get information about an unacknowledged insert many");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public int hashCode() {
            return 0;
        }

        public String toString() {
            return "UnacknowledgedInsertManyResult{}";
        }
    }
}

