/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.connection.netty;

import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.connection.SocketSettings;
import com.willfp.eco.libs.mongodb.connection.SslSettings;
import com.willfp.eco.libs.mongodb.connection.StreamFactory;
import com.willfp.eco.libs.mongodb.connection.StreamFactoryFactory;
import com.willfp.eco.libs.mongodb.connection.netty.NettyStreamFactory;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.ssl.ReferenceCountedOpenSslClientContext;
import io.netty.handler.ssl.SslContext;

public final class NettyStreamFactoryFactory
implements StreamFactoryFactory {
    private final EventLoopGroup eventLoopGroup;
    private final Class<? extends SocketChannel> socketChannelClass;
    private final ByteBufAllocator allocator;
    @Nullable
    private final SslContext sslContext;

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public StreamFactory create(SocketSettings socketSettings, SslSettings sslSettings) {
        return new NettyStreamFactory(socketSettings, sslSettings, this.eventLoopGroup, this.socketChannelClass, this.allocator, this.sslContext);
    }

    public String toString() {
        return "NettyStreamFactoryFactory{eventLoopGroup=" + this.eventLoopGroup + ", socketChannelClass=" + this.socketChannelClass + ", allocator=" + this.allocator + ", sslContext=" + this.sslContext + '}';
    }

    private NettyStreamFactoryFactory(Builder builder) {
        this.allocator = builder.allocator;
        this.socketChannelClass = builder.socketChannelClass;
        this.eventLoopGroup = builder.eventLoopGroup != null ? builder.eventLoopGroup : new NioEventLoopGroup();
        this.sslContext = builder.sslContext;
    }

    public static final class Builder {
        private ByteBufAllocator allocator;
        private Class<? extends SocketChannel> socketChannelClass;
        private EventLoopGroup eventLoopGroup;
        @Nullable
        private SslContext sslContext;

        private Builder() {
            this.allocator(ByteBufAllocator.DEFAULT);
            this.socketChannelClass(NioSocketChannel.class);
        }

        public Builder allocator(ByteBufAllocator allocator) {
            this.allocator = Assertions.notNull("allocator", allocator);
            return this;
        }

        public Builder socketChannelClass(Class<? extends SocketChannel> socketChannelClass) {
            this.socketChannelClass = Assertions.notNull("socketChannelClass", socketChannelClass);
            return this;
        }

        public Builder eventLoopGroup(EventLoopGroup eventLoopGroup) {
            this.eventLoopGroup = Assertions.notNull("eventLoopGroup", eventLoopGroup);
            return this;
        }

        public Builder sslContext(SslContext sslContext) {
            this.sslContext = Assertions.notNull("sslContext", sslContext);
            Assertions.isTrueArgument("sslContext must be client-side", sslContext.isClient());
            Assertions.isTrueArgument("sslContext must use either SslProvider.JDK or SslProvider.OPENSSL TLS/SSL protocol provider", !(sslContext instanceof ReferenceCountedOpenSslClientContext));
            return this;
        }

        public NettyStreamFactoryFactory build() {
            return new NettyStreamFactoryFactory(this);
        }
    }
}

