/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.event;

import com.willfp.eco.libs.mongodb.RequestContext;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.connection.ConnectionDescription;
import com.willfp.eco.libs.mongodb.event.CommandEvent;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.concurrent.TimeUnit;

public final class CommandFailedEvent
extends CommandEvent {
    private final long elapsedTimeNanos;
    private final Throwable throwable;

    public CommandFailedEvent(@Nullable RequestContext requestContext, long operationId, int requestId, ConnectionDescription connectionDescription, String commandName, long elapsedTimeNanos, Throwable throwable) {
        super(requestContext, operationId, requestId, connectionDescription, commandName);
        Assertions.isTrueArgument("elapsed time is not negative", elapsedTimeNanos >= 0L);
        this.elapsedTimeNanos = elapsedTimeNanos;
        this.throwable = throwable;
    }

    @Deprecated
    public CommandFailedEvent(@Nullable RequestContext requestContext, int requestId, ConnectionDescription connectionDescription, String commandName, long elapsedTimeNanos, Throwable throwable) {
        this(requestContext, -1L, requestId, connectionDescription, commandName, elapsedTimeNanos, throwable);
    }

    @Deprecated
    public CommandFailedEvent(int requestId, ConnectionDescription connectionDescription, String commandName, long elapsedTimeNanos, Throwable throwable) {
        this(null, requestId, connectionDescription, commandName, elapsedTimeNanos, throwable);
    }

    public long getElapsedTime(TimeUnit timeUnit) {
        return timeUnit.convert(this.elapsedTimeNanos, TimeUnit.NANOSECONDS);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }
}

