/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.async;

import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.internal.async.SingleResultCallback;
import com.willfp.eco.libs.mongodb.internal.diagnostics.logging.Logger;
import com.willfp.eco.libs.mongodb.lang.Nullable;

public class ErrorHandlingResultCallback<T>
implements SingleResultCallback<T> {
    private final SingleResultCallback<T> wrapped;
    private final Logger logger;

    public static <T> SingleResultCallback<T> errorHandlingCallback(SingleResultCallback<T> callback, Logger logger) {
        if (callback instanceof ErrorHandlingResultCallback) {
            return callback;
        }
        return new ErrorHandlingResultCallback<T>(callback, logger);
    }

    ErrorHandlingResultCallback(SingleResultCallback<T> wrapped, Logger logger) {
        this.wrapped = Assertions.notNull("wrapped", wrapped);
        this.logger = Assertions.notNull("logger", logger);
    }

    @Override
    public void onResult(@Nullable T result2, @Nullable Throwable t2) {
        try {
            this.wrapped.onResult(result2, t2);
        }
        catch (Throwable e) {
            this.logger.error("Callback onResult call produced an error", e);
        }
    }
}

