/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.client.vault;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonInt32;
import com.willfp.eco.libs.bson.BsonInt64;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.mongodb.client.model.vault.EncryptOptions;
import com.willfp.eco.libs.mongodb.client.model.vault.RangeOptions;
import com.willfp.eco.libs.mongodb.crypt.capi.MongoExplicitEncryptOptions;

public final class EncryptOptionsHelper {
    public static MongoExplicitEncryptOptions asMongoExplicitEncryptOptions(EncryptOptions options2) {
        RangeOptions rangeOptions;
        MongoExplicitEncryptOptions.Builder encryptOptionsBuilder = MongoExplicitEncryptOptions.builder().algorithm(options2.getAlgorithm());
        if (options2.getKeyId() != null) {
            encryptOptionsBuilder.keyId(options2.getKeyId());
        }
        if (options2.getKeyAltName() != null) {
            encryptOptionsBuilder.keyAltName(options2.getKeyAltName());
        }
        if (options2.getContentionFactor() != null) {
            encryptOptionsBuilder.contentionFactor(options2.getContentionFactor());
        }
        if (options2.getQueryType() != null) {
            encryptOptionsBuilder.queryType(options2.getQueryType());
        }
        if ((rangeOptions = options2.getRangeOptions()) != null) {
            Integer precision;
            Long sparsity;
            BsonValue max;
            BsonDocument rangeOptionsBsonDocument = new BsonDocument();
            BsonValue min2 = rangeOptions.getMin();
            if (min2 != null) {
                rangeOptionsBsonDocument.put("min", min2);
            }
            if ((max = rangeOptions.getMax()) != null) {
                rangeOptionsBsonDocument.put("max", max);
            }
            if ((sparsity = rangeOptions.getSparsity()) != null) {
                rangeOptionsBsonDocument.put("sparsity", new BsonInt64(sparsity));
            }
            if ((precision = rangeOptions.getPrecision()) != null) {
                rangeOptionsBsonDocument.put("precision", new BsonInt32(precision));
            }
            encryptOptionsBuilder.rangeOptions(rangeOptionsBsonDocument);
        }
        return encryptOptionsBuilder.build();
    }

    private EncryptOptionsHelper() {
    }
}

