/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.connection;

import com.willfp.eco.libs.mongodb.MongoCredential;
import com.willfp.eco.libs.mongodb.MongoInternalException;
import com.willfp.eco.libs.mongodb.ServerApi;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.connection.ClusterConnectionMode;
import com.willfp.eco.libs.mongodb.connection.ConnectionDescription;
import com.willfp.eco.libs.mongodb.internal.async.SingleResultCallback;
import com.willfp.eco.libs.mongodb.internal.connection.InternalConnection;
import com.willfp.eco.libs.mongodb.internal.connection.MongoCredentialWithCache;
import com.willfp.eco.libs.mongodb.lang.NonNull;
import com.willfp.eco.libs.mongodb.lang.Nullable;

public abstract class Authenticator {
    private final MongoCredentialWithCache credential;
    private final ClusterConnectionMode clusterConnectionMode;
    private final ServerApi serverApi;

    Authenticator(@NonNull MongoCredentialWithCache credential, ClusterConnectionMode clusterConnectionMode, @Nullable ServerApi serverApi) {
        this.credential = credential;
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.serverApi = serverApi;
    }

    @NonNull
    MongoCredentialWithCache getMongoCredentialWithCache() {
        return this.credential;
    }

    @NonNull
    MongoCredential getMongoCredential() {
        return this.credential.getCredential();
    }

    ClusterConnectionMode getClusterConnectionMode() {
        return this.clusterConnectionMode;
    }

    @Nullable
    ServerApi getServerApi() {
        return this.serverApi;
    }

    @NonNull
    String getUserNameNonNull() {
        String userName = this.credential.getCredential().getUserName();
        if (userName == null) {
            throw new MongoInternalException("User name can not be null");
        }
        return userName;
    }

    @NonNull
    char[] getPasswordNonNull() {
        char[] password = this.credential.getCredential().getPassword();
        if (password == null) {
            throw new MongoInternalException("Password can not be null");
        }
        return password;
    }

    @NonNull
    <T> T getNonNullMechanismProperty(String key, @Nullable T defaultValue) {
        T mechanismProperty = this.credential.getCredential().getMechanismProperty(key, defaultValue);
        if (mechanismProperty == null) {
            throw new MongoInternalException("Mechanism property can not be null");
        }
        return mechanismProperty;
    }

    abstract void authenticate(InternalConnection var1, ConnectionDescription var2);

    abstract void authenticateAsync(InternalConnection var1, ConnectionDescription var2, SingleResultCallback<Void> var3);
}

