/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.connection;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonElement;
import com.willfp.eco.libs.bson.BsonMaximumSizeExceededException;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.BsonWriter;
import com.willfp.eco.libs.bson.codecs.BsonValueCodecProvider;
import com.willfp.eco.libs.bson.codecs.Codec;
import com.willfp.eco.libs.bson.codecs.EncoderContext;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistries;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.bson.io.BsonOutput;
import com.willfp.eco.libs.mongodb.internal.connection.MessageSettings;
import com.willfp.eco.libs.mongodb.internal.connection.SplittablePayload;
import java.util.List;

final class BsonWriterHelper {
    private static final int DOCUMENT_HEADROOM = 16384;
    private static final CodecRegistry REGISTRY = CodecRegistries.fromProviders(new BsonValueCodecProvider());
    private static final EncoderContext ENCODER_CONTEXT = EncoderContext.builder().build();

    static void writeElements(BsonWriter writer, List<BsonElement> bsonElements) {
        for (BsonElement bsonElement : bsonElements) {
            writer.writeName(bsonElement.getName());
            BsonWriterHelper.getCodec(bsonElement.getValue()).encode(writer, bsonElement.getValue(), ENCODER_CONTEXT);
        }
    }

    static void writePayloadArray(BsonWriter writer, BsonOutput bsonOutput, MessageSettings settings, int messageStartPosition, SplittablePayload payload, int maxSplittableDocumentSize) {
        writer.writeStartArray(payload.getPayloadName());
        BsonWriterHelper.writePayload(writer, bsonOutput, BsonWriterHelper.getDocumentMessageSettings(settings), messageStartPosition, payload, maxSplittableDocumentSize);
        writer.writeEndArray();
    }

    static void writePayload(BsonWriter writer, BsonOutput bsonOutput, MessageSettings settings, int messageStartPosition, SplittablePayload payload, int maxSplittableDocumentSize) {
        MessageSettings payloadSettings = BsonWriterHelper.getPayloadMessageSettings(payload.getPayloadType(), settings);
        List<BsonDocument> payloadDocuments = payload.getPayload();
        for (int i = 0; i < payloadDocuments.size() && BsonWriterHelper.writeDocument(writer, bsonOutput, payloadSettings, payloadDocuments.get(i), messageStartPosition, i + 1, maxSplittableDocumentSize); ++i) {
            payload.setPosition(i + 1);
        }
        if (payload.getPosition() == 0) {
            throw new BsonMaximumSizeExceededException(String.format("Payload document size is larger than maximum of %d.", payloadSettings.getMaxDocumentSize()));
        }
    }

    private static boolean writeDocument(BsonWriter writer, BsonOutput bsonOutput, MessageSettings settings, BsonDocument document2, int messageStartPosition, int batchItemCount, int maxSplittableDocumentSize) {
        int currentPosition = bsonOutput.getPosition();
        BsonWriterHelper.getCodec(document2).encode(writer, document2, ENCODER_CONTEXT);
        int messageSize = bsonOutput.getPosition() - messageStartPosition;
        int documentSize = bsonOutput.getPosition() - currentPosition;
        if (BsonWriterHelper.exceedsLimits(settings, messageSize, documentSize, batchItemCount) || batchItemCount > 1 && bsonOutput.getPosition() - messageStartPosition > maxSplittableDocumentSize) {
            bsonOutput.truncateToPosition(currentPosition);
            return false;
        }
        return true;
    }

    private static Codec<BsonValue> getCodec(BsonValue bsonValue) {
        return REGISTRY.get(bsonValue.getClass());
    }

    private static MessageSettings getPayloadMessageSettings(SplittablePayload.Type type2, MessageSettings settings) {
        MessageSettings payloadMessageSettings = settings;
        if (type2 != SplittablePayload.Type.INSERT) {
            payloadMessageSettings = BsonWriterHelper.createMessageSettingsBuilder(settings).maxDocumentSize(settings.getMaxDocumentSize() + 16384).build();
        }
        return payloadMessageSettings;
    }

    private static MessageSettings getDocumentMessageSettings(MessageSettings settings) {
        return BsonWriterHelper.createMessageSettingsBuilder(settings).maxMessageSize(settings.getMaxDocumentSize() + 16384).build();
    }

    private static MessageSettings.Builder createMessageSettingsBuilder(MessageSettings settings) {
        return MessageSettings.builder().maxBatchCount(settings.getMaxBatchCount()).maxMessageSize(settings.getMaxMessageSize()).maxDocumentSize(settings.getMaxDocumentSize()).maxWireVersion(settings.getMaxWireVersion());
    }

    private static boolean exceedsLimits(MessageSettings settings, int messageSize, int documentSize, int batchItemCount) {
        if (batchItemCount > settings.getMaxBatchCount()) {
            return true;
        }
        if (messageSize > settings.getMaxMessageSize()) {
            return true;
        }
        return documentSize > settings.getMaxDocumentSize();
    }

    private BsonWriterHelper() {
    }
}

