/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.connection;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.FieldNameValidator;
import com.willfp.eco.libs.bson.codecs.Decoder;
import com.willfp.eco.libs.mongodb.ReadPreference;
import com.willfp.eco.libs.mongodb.connection.ClusterConnectionMode;
import com.willfp.eco.libs.mongodb.connection.ConnectionDescription;
import com.willfp.eco.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import com.willfp.eco.libs.mongodb.internal.async.SingleResultCallback;
import com.willfp.eco.libs.mongodb.internal.binding.BindingContext;
import com.willfp.eco.libs.mongodb.internal.connection.AbstractReferenceCounted;
import com.willfp.eco.libs.mongodb.internal.connection.AsyncConnection;
import com.willfp.eco.libs.mongodb.internal.connection.CommandProtocol;
import com.willfp.eco.libs.mongodb.internal.connection.CommandProtocolImpl;
import com.willfp.eco.libs.mongodb.internal.connection.Connection;
import com.willfp.eco.libs.mongodb.internal.connection.InternalConnection;
import com.willfp.eco.libs.mongodb.internal.connection.ProtocolExecutor;
import com.willfp.eco.libs.mongodb.internal.connection.SplittablePayload;
import com.willfp.eco.libs.mongodb.internal.diagnostics.logging.Logger;
import com.willfp.eco.libs.mongodb.internal.diagnostics.logging.Loggers;
import com.willfp.eco.libs.mongodb.internal.session.SessionContext;
import com.willfp.eco.libs.mongodb.lang.Nullable;

public class DefaultServerConnection
extends AbstractReferenceCounted
implements Connection,
AsyncConnection {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final InternalConnection wrapped;
    private final ProtocolExecutor protocolExecutor;
    private final ClusterConnectionMode clusterConnectionMode;

    public DefaultServerConnection(InternalConnection wrapped, ProtocolExecutor protocolExecutor, ClusterConnectionMode clusterConnectionMode) {
        this.wrapped = wrapped;
        this.protocolExecutor = protocolExecutor;
        this.clusterConnectionMode = clusterConnectionMode;
    }

    @Override
    public DefaultServerConnection retain() {
        super.retain();
        return this;
    }

    @Override
    public int release() {
        int count2 = super.release();
        if (count2 == 0) {
            this.wrapped.close();
        }
        return count2;
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.wrapped.getDescription();
    }

    @Override
    @Nullable
    public <T> T command(String database, BsonDocument command2, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, BindingContext context) {
        return this.command(database, command2, fieldNameValidator, readPreference, commandResultDecoder, context, true, null, null);
    }

    @Override
    @Nullable
    public <T> T command(String database, BsonDocument command2, FieldNameValidator commandFieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, BindingContext context, boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator) {
        return this.executeProtocol(new CommandProtocolImpl<T>(database, command2, commandFieldNameValidator, readPreference, commandResultDecoder, responseExpected, payload, payloadFieldNameValidator, this.clusterConnectionMode, context.getServerApi(), context.getRequestContext(), context.getOperationContext()), context.getSessionContext());
    }

    @Override
    public <T> void commandAsync(String database, BsonDocument command2, FieldNameValidator fieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, BindingContext context, SingleResultCallback<T> callback) {
        this.commandAsync(database, command2, fieldNameValidator, readPreference, commandResultDecoder, context, true, null, null, callback);
    }

    @Override
    public <T> void commandAsync(String database, BsonDocument command2, FieldNameValidator commandFieldNameValidator, @Nullable ReadPreference readPreference, Decoder<T> commandResultDecoder, BindingContext context, boolean responseExpected, @Nullable SplittablePayload payload, @Nullable FieldNameValidator payloadFieldNameValidator, SingleResultCallback<T> callback) {
        this.executeProtocolAsync(new CommandProtocolImpl<T>(database, command2, commandFieldNameValidator, readPreference, commandResultDecoder, responseExpected, payload, payloadFieldNameValidator, this.clusterConnectionMode, context.getServerApi(), context.getRequestContext(), context.getOperationContext()), context.getSessionContext(), callback);
    }

    @Override
    public void markAsPinned(Connection.PinningMode pinningMode) {
        this.wrapped.markAsPinned(pinningMode);
    }

    @Nullable
    private <T> T executeProtocol(CommandProtocol<T> protocol, SessionContext sessionContext) {
        return this.protocolExecutor.execute(protocol, this.wrapped, sessionContext);
    }

    private <T> void executeProtocolAsync(CommandProtocol<T> protocol, SessionContext sessionContext, SingleResultCallback<T> callback) {
        SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, LOGGER);
        try {
            this.protocolExecutor.executeAsync(protocol, this.wrapped, sessionContext, errHandlingCallback);
        }
        catch (Throwable t2) {
            errHandlingCallback.onResult(null, t2);
        }
    }
}

