/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.connection;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonInt32;
import com.willfp.eco.libs.bson.BsonReader;
import com.willfp.eco.libs.bson.codecs.RawBsonDocumentCodec;
import com.willfp.eco.libs.bson.json.JsonMode;
import com.willfp.eco.libs.bson.json.JsonWriter;
import com.willfp.eco.libs.bson.json.JsonWriterSettings;
import com.willfp.eco.libs.mongodb.LoggerSettings;
import com.willfp.eco.libs.mongodb.MongoCommandException;
import com.willfp.eco.libs.mongodb.RequestContext;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.connection.ClusterId;
import com.willfp.eco.libs.mongodb.connection.ConnectionDescription;
import com.willfp.eco.libs.mongodb.event.CommandListener;
import com.willfp.eco.libs.mongodb.internal.connection.ByteBufferBsonOutput;
import com.willfp.eco.libs.mongodb.internal.connection.CommandEventSender;
import com.willfp.eco.libs.mongodb.internal.connection.CommandMessage;
import com.willfp.eco.libs.mongodb.internal.connection.OperationContext;
import com.willfp.eco.libs.mongodb.internal.connection.ProtocolHelper;
import com.willfp.eco.libs.mongodb.internal.connection.ResponseBuffers;
import com.willfp.eco.libs.mongodb.internal.logging.LogMessage;
import com.willfp.eco.libs.mongodb.internal.logging.StructuredLogger;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;

class LoggingCommandEventSender
implements CommandEventSender {
    private static final double NANOS_PER_MILLI = 1000000.0;
    private final ConnectionDescription description;
    @Nullable
    private final CommandListener commandListener;
    private final RequestContext requestContext;
    private final OperationContext operationContext;
    private final StructuredLogger logger;
    private final LoggerSettings loggerSettings;
    private final long startTimeNanos;
    private final CommandMessage message;
    private final String commandName;
    private volatile BsonDocument commandDocument;
    private final boolean redactionRequired;

    LoggingCommandEventSender(Set<String> securitySensitiveCommands, Set<String> securitySensitiveHelloCommands, ConnectionDescription description2, @Nullable CommandListener commandListener, RequestContext requestContext, OperationContext operationContext, CommandMessage message, ByteBufferBsonOutput bsonOutput, StructuredLogger logger, LoggerSettings loggerSettings) {
        this.description = description2;
        this.commandListener = commandListener;
        this.requestContext = requestContext;
        this.operationContext = operationContext;
        this.logger = logger;
        this.loggerSettings = loggerSettings;
        this.startTimeNanos = System.nanoTime();
        this.message = message;
        this.commandDocument = message.getCommandDocument(bsonOutput);
        this.commandName = this.commandDocument.getFirstKey();
        this.redactionRequired = securitySensitiveCommands.contains(this.commandName) || securitySensitiveHelloCommands.contains(this.commandName) && this.commandDocument.containsKey("speculativeAuthenticate");
    }

    @Override
    public void sendStartedEvent() {
        if (this.loggingRequired()) {
            String messagePrefix = "Command \"{}\" started on database {}";
            String command2 = this.redactionRequired ? "{}" : this.getTruncatedJsonCommand(this.commandDocument);
            this.logEventMessage(messagePrefix, "Command started", null, (List<LogMessage.Entry> entries2) -> {
                entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.COMMAND_NAME, this.commandName));
                entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.DATABASE_NAME, this.message.getNamespace().getDatabaseName()));
            }, (List<LogMessage.Entry> entries2) -> entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.COMMAND_CONTENT, command2)));
        }
        if (this.eventRequired()) {
            BsonDocument commandDocumentForEvent = this.redactionRequired ? new BsonDocument() : this.commandDocument;
            ProtocolHelper.sendCommandStartedEvent(this.message, this.message.getNamespace().getDatabaseName(), this.commandName, commandDocumentForEvent, this.description, Assertions.assertNotNull(this.commandListener), this.requestContext, this.operationContext);
        }
        this.commandDocument = null;
    }

    @Override
    public void sendFailedEvent(Throwable t2) {
        Throwable commandEventException = t2;
        if (t2 instanceof MongoCommandException && this.redactionRequired) {
            MongoCommandException originalCommandException = (MongoCommandException)t2;
            commandEventException = new MongoCommandException(new BsonDocument(), originalCommandException.getServerAddress());
            commandEventException.setStackTrace(t2.getStackTrace());
        }
        long elapsedTimeNanos = System.nanoTime() - this.startTimeNanos;
        if (this.loggingRequired()) {
            String messagePrefix = "Command \"{}\" failed in {} ms";
            this.logEventMessage(messagePrefix, "Command failed", commandEventException, (List<LogMessage.Entry> entries2) -> {
                entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.COMMAND_NAME, this.commandName));
                entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.DURATION_MS, (double)elapsedTimeNanos / 1000000.0));
            }, (List<LogMessage.Entry> entries2) -> entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.COMMAND_CONTENT, null)));
        }
        if (this.eventRequired()) {
            ProtocolHelper.sendCommandFailedEvent(this.message, this.commandName, this.description, elapsedTimeNanos, commandEventException, this.commandListener, this.requestContext, this.operationContext);
        }
    }

    @Override
    public void sendSucceededEvent(ResponseBuffers responseBuffers) {
        this.sendSucceededEvent(responseBuffers.getResponseDocument(this.message.getId(), new RawBsonDocumentCodec()));
    }

    @Override
    public void sendSucceededEventForOneWayCommand() {
        this.sendSucceededEvent(new BsonDocument("ok", new BsonInt32(1)));
    }

    private void sendSucceededEvent(BsonDocument reply) {
        long elapsedTimeNanos = System.nanoTime() - this.startTimeNanos;
        if (this.loggingRequired()) {
            String format = "Command \"{}\" succeeded in {} ms using a connection with driver-generated ID {}[ and server-generated ID {}] to {}:{}[ with service ID {}]. The request ID is {} and the operation ID is {}. Command reply: {}";
            BsonDocument responseDocumentForEvent = this.redactionRequired ? new BsonDocument() : reply;
            String replyString = this.redactionRequired ? "{}" : this.getTruncatedJsonCommand(responseDocumentForEvent);
            this.logEventMessage("Command succeeded", null, (List<LogMessage.Entry> entries2) -> {
                entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.COMMAND_NAME, this.commandName));
                entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.DURATION_MS, (double)elapsedTimeNanos / 1000000.0));
            }, (List<LogMessage.Entry> entries2) -> entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.REPLY, replyString)), format);
        }
        if (this.eventRequired()) {
            BsonDocument responseDocumentForEvent = this.redactionRequired ? new BsonDocument() : reply;
            ProtocolHelper.sendCommandSucceededEvent(this.message, this.commandName, responseDocumentForEvent, this.description, elapsedTimeNanos, this.commandListener, this.requestContext, this.operationContext);
        }
    }

    private boolean loggingRequired() {
        return this.logger.isRequired(LogMessage.Level.DEBUG, this.getClusterId());
    }

    private ClusterId getClusterId() {
        return this.description.getConnectionId().getServerId().getClusterId();
    }

    private boolean eventRequired() {
        return this.commandListener != null;
    }

    private void logEventMessage(String messagePrefix, String messageId, @Nullable Throwable exception, Consumer<List<LogMessage.Entry>> prefixEntriesMutator, Consumer<List<LogMessage.Entry>> suffixEntriesMutator) {
        String format = messagePrefix + " using a connection with driver-generated ID {}[ and server-generated ID {}] to {}:{}[ with service ID {}]. The request ID is {} and the operation ID is {}.[ Command: {}]";
        this.logEventMessage(messageId, exception, prefixEntriesMutator, suffixEntriesMutator, format);
    }

    private void logEventMessage(String messageId, @Nullable Throwable exception, Consumer<List<LogMessage.Entry>> prefixEntriesMutator, Consumer<List<LogMessage.Entry>> suffixEntriesMutator, String format) {
        ArrayList<LogMessage.Entry> entries2 = new ArrayList<LogMessage.Entry>();
        prefixEntriesMutator.accept(entries2);
        entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.DRIVER_CONNECTION_ID, this.description.getConnectionId().getLocalValue()));
        entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.SERVER_CONNECTION_ID, this.description.getConnectionId().getServerValue()));
        entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.SERVER_HOST, this.description.getServerAddress().getHost()));
        entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.SERVER_PORT, this.description.getServerAddress().getPort()));
        entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.SERVICE_ID, this.description.getServiceId()));
        entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.REQUEST_ID, this.message.getId()));
        entries2.add(new LogMessage.Entry(LogMessage.Entry.Name.OPERATION_ID, this.operationContext.getId()));
        suffixEntriesMutator.accept(entries2);
        this.logger.log(new LogMessage(LogMessage.Component.COMMAND, LogMessage.Level.DEBUG, messageId, this.getClusterId(), exception, entries2, format));
    }

    private String getTruncatedJsonCommand(BsonDocument commandDocument) {
        StringWriter writer = new StringWriter();
        try (BsonReader bsonReader = commandDocument.asBsonReader();){
            JsonWriter jsonWriter = new JsonWriter(writer, JsonWriterSettings.builder().outputMode(JsonMode.RELAXED).maxLength(this.loggerSettings.getMaxDocumentLength()).build());
            jsonWriter.pipe(bsonReader);
            if (jsonWriter.isTruncated()) {
                writer.append(" ...");
            }
            String string = writer.toString();
            return string;
        }
    }
}

