/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.connection;

import com.willfp.eco.libs.bson.BsonBinaryReader;
import com.willfp.eco.libs.bson.codecs.Decoder;
import com.willfp.eco.libs.bson.codecs.DecoderContext;
import com.willfp.eco.libs.bson.io.ByteBufferBsonInput;
import com.willfp.eco.libs.mongodb.MongoInternalException;
import com.willfp.eco.libs.mongodb.internal.connection.ReplyHeader;
import com.willfp.eco.libs.mongodb.internal.connection.ResponseBuffers;
import java.util.ArrayList;
import java.util.List;

public class ReplyMessage<T> {
    private final ReplyHeader replyHeader;
    private final List<T> documents;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReplyMessage(ResponseBuffers responseBuffers, Decoder<T> decoder, long requestId) {
        this(responseBuffers.getReplyHeader(), requestId);
        if (this.replyHeader.getNumberReturned() > 0) {
            try (ByteBufferBsonInput bsonInput = new ByteBufferBsonInput(responseBuffers.getBodyByteBuffer().duplicate());){
                while (this.documents.size() < this.replyHeader.getNumberReturned()) {
                    try (BsonBinaryReader reader = new BsonBinaryReader(bsonInput);){
                        this.documents.add(decoder.decode(reader, DecoderContext.builder().build()));
                    }
                }
            }
            finally {
                responseBuffers.reset();
            }
        }
    }

    ReplyMessage(ReplyHeader replyHeader, long requestId) {
        if (requestId != (long)replyHeader.getResponseTo()) {
            throw new MongoInternalException(String.format("The responseTo (%d) in the response does not match the requestId (%d) in the request", replyHeader.getResponseTo(), requestId));
        }
        this.replyHeader = replyHeader;
        this.documents = new ArrayList<T>(replyHeader.getNumberReturned());
    }

    public ReplyHeader getReplyHeader() {
        return this.replyHeader;
    }

    public List<T> getDocuments() {
        return this.documents;
    }
}

