/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.connection;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.mongodb.MongoCommandException;
import com.willfp.eco.libs.mongodb.connection.TopologyVersion;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.Optional;

final class TopologyVersionHelper {
    static boolean newer(@Nullable TopologyVersion current, @Nullable TopologyVersion candidate) {
        return TopologyVersionHelper.compare(current, candidate) > 0;
    }

    static boolean newerOrEqual(@Nullable TopologyVersion current, @Nullable TopologyVersion candidate) {
        return TopologyVersionHelper.compare(current, candidate) >= 0;
    }

    static Optional<TopologyVersion> topologyVersion(@Nullable Throwable t2) {
        BsonDocument rawTopologyVersion;
        TopologyVersion result2 = null;
        if (t2 instanceof MongoCommandException && (rawTopologyVersion = ((MongoCommandException)t2).getResponse().getDocument("topologyVersion", null)) != null) {
            result2 = new TopologyVersion(rawTopologyVersion);
        }
        return Optional.ofNullable(result2);
    }

    private static int compare(@Nullable TopologyVersion o1, @Nullable TopologyVersion o2) {
        if (o1 == null || o2 == null) {
            return -1;
        }
        if (o1.getProcessId().equals(o2.getProcessId())) {
            return Long.compare(o1.getCounter(), o2.getCounter());
        }
        return -1;
    }

    private TopologyVersionHelper() {
        throw new AssertionError();
    }
}

