/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.connection;

import com.willfp.eco.libs.bson.ByteBuf;
import com.willfp.eco.libs.bson.codecs.Decoder;
import com.willfp.eco.libs.mongodb.RequestContext;
import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.connection.ConnectionDescription;
import com.willfp.eco.libs.mongodb.connection.ServerDescription;
import com.willfp.eco.libs.mongodb.internal.async.ErrorHandlingResultCallback;
import com.willfp.eco.libs.mongodb.internal.async.SingleResultCallback;
import com.willfp.eco.libs.mongodb.internal.connection.CommandMessage;
import com.willfp.eco.libs.mongodb.internal.connection.DefaultConnectionPool;
import com.willfp.eco.libs.mongodb.internal.connection.InternalConnection;
import com.willfp.eco.libs.mongodb.internal.connection.OperationContext;
import com.willfp.eco.libs.mongodb.internal.connection.ResponseBuffers;
import com.willfp.eco.libs.mongodb.internal.diagnostics.logging.Logger;
import com.willfp.eco.libs.mongodb.internal.diagnostics.logging.Loggers;
import com.willfp.eco.libs.mongodb.internal.session.SessionContext;
import java.util.List;

class UsageTrackingInternalConnection
implements InternalConnection {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private volatile long openedAt;
    private volatile long lastUsedAt;
    private volatile boolean closeSilently;
    private final InternalConnection wrapped;
    private final DefaultConnectionPool.ServiceStateManager serviceStateManager;

    UsageTrackingInternalConnection(InternalConnection wrapped, DefaultConnectionPool.ServiceStateManager serviceStateManager) {
        this.wrapped = wrapped;
        this.serviceStateManager = serviceStateManager;
        this.lastUsedAt = this.openedAt = Long.MAX_VALUE;
    }

    @Override
    public void open() {
        this.wrapped.open();
        this.lastUsedAt = this.openedAt = System.currentTimeMillis();
        if (this.getDescription().getServiceId() != null) {
            this.serviceStateManager.addConnection(Assertions.assertNotNull(this.getDescription().getServiceId()));
        }
    }

    @Override
    public void openAsync(SingleResultCallback<Void> callback) {
        this.wrapped.openAsync((result2, t2) -> {
            if (t2 != null) {
                callback.onResult(null, t2);
            } else {
                this.lastUsedAt = this.openedAt = System.currentTimeMillis();
                if (this.getDescription().getServiceId() != null) {
                    this.serviceStateManager.addConnection(this.getDescription().getServiceId());
                }
                callback.onResult(null, null);
            }
        });
    }

    @Override
    public void close() {
        try {
            this.wrapped.close();
        }
        finally {
            if (this.openedAt != Long.MAX_VALUE && this.getDescription().getServiceId() != null) {
                this.serviceStateManager.removeConnection(Assertions.assertNotNull(this.getDescription().getServiceId()));
            }
        }
    }

    @Override
    public boolean opened() {
        return this.wrapped.opened();
    }

    @Override
    public boolean isClosed() {
        return this.wrapped.isClosed();
    }

    @Override
    public ByteBuf getBuffer(int size) {
        return this.wrapped.getBuffer(size);
    }

    @Override
    public void sendMessage(List<ByteBuf> byteBuffers, int lastRequestId) {
        this.wrapped.sendMessage(byteBuffers, lastRequestId);
        this.lastUsedAt = System.currentTimeMillis();
    }

    @Override
    public <T> T sendAndReceive(CommandMessage message, Decoder<T> decoder, SessionContext sessionContext, RequestContext requestContext, OperationContext operationContext) {
        T result2 = this.wrapped.sendAndReceive(message, decoder, sessionContext, requestContext, operationContext);
        this.lastUsedAt = System.currentTimeMillis();
        return result2;
    }

    @Override
    public <T> void send(CommandMessage message, Decoder<T> decoder, SessionContext sessionContext) {
        this.wrapped.send(message, decoder, sessionContext);
        this.lastUsedAt = System.currentTimeMillis();
    }

    @Override
    public <T> T receive(Decoder<T> decoder, SessionContext sessionContext) {
        T result2 = this.wrapped.receive(decoder, sessionContext);
        this.lastUsedAt = System.currentTimeMillis();
        return result2;
    }

    @Override
    public boolean supportsAdditionalTimeout() {
        return this.wrapped.supportsAdditionalTimeout();
    }

    @Override
    public <T> T receive(Decoder<T> decoder, SessionContext sessionContext, int additionalTimeout) {
        T result2 = this.wrapped.receive(decoder, sessionContext, additionalTimeout);
        this.lastUsedAt = System.currentTimeMillis();
        return result2;
    }

    @Override
    public boolean hasMoreToCome() {
        return this.wrapped.hasMoreToCome();
    }

    @Override
    public <T> void sendAndReceiveAsync(CommandMessage message, Decoder<T> decoder, SessionContext sessionContext, RequestContext requestContext, OperationContext operationContext, SingleResultCallback<T> callback) {
        SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback((result2, t2) -> {
            this.lastUsedAt = System.currentTimeMillis();
            callback.onResult(result2, t2);
        }, LOGGER);
        this.wrapped.sendAndReceiveAsync(message, decoder, sessionContext, requestContext, operationContext, errHandlingCallback);
    }

    @Override
    public ResponseBuffers receiveMessage(int responseTo) {
        ResponseBuffers responseBuffers = this.wrapped.receiveMessage(responseTo);
        this.lastUsedAt = System.currentTimeMillis();
        return responseBuffers;
    }

    @Override
    public void sendMessageAsync(List<ByteBuf> byteBuffers, int lastRequestId, SingleResultCallback<Void> callback) {
        SingleResultCallback<Void> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback((result2, t2) -> {
            this.lastUsedAt = System.currentTimeMillis();
            callback.onResult((Void)result2, t2);
        }, LOGGER);
        this.wrapped.sendMessageAsync(byteBuffers, lastRequestId, errHandlingCallback);
    }

    @Override
    public void receiveMessageAsync(int responseTo, SingleResultCallback<ResponseBuffers> callback) {
        SingleResultCallback<ResponseBuffers> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback((result2, t2) -> {
            this.lastUsedAt = System.currentTimeMillis();
            callback.onResult((ResponseBuffers)result2, t2);
        }, LOGGER);
        this.wrapped.receiveMessageAsync(responseTo, errHandlingCallback);
    }

    @Override
    public ConnectionDescription getDescription() {
        return this.wrapped.getDescription();
    }

    @Override
    public ServerDescription getInitialServerDescription() {
        return this.wrapped.getInitialServerDescription();
    }

    @Override
    public int getGeneration() {
        return this.wrapped.getGeneration();
    }

    long getOpenedAt() {
        return this.openedAt;
    }

    long getLastUsedAt() {
        return this.lastUsedAt;
    }

    void setCloseSilently() {
        this.closeSilently = true;
    }

    boolean isCloseSilently() {
        return this.closeSilently;
    }
}

