/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.logging;

import com.willfp.eco.libs.mongodb.assertions.Assertions;
import com.willfp.eco.libs.mongodb.connection.ClusterId;
import com.willfp.eco.libs.mongodb.lang.Nullable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public final class LogMessage {
    private final Component component;
    private final Level level;
    private final String messageId;
    private final ClusterId clusterId;
    private final Throwable exception;
    private final Collection<Entry> entries;
    private final String format;

    public LogMessage(Component component, Level level, String messageId, ClusterId clusterId, List<Entry> entries2, String format) {
        this(component, level, messageId, clusterId, null, entries2, format);
    }

    public LogMessage(Component component, Level level, String messageId, ClusterId clusterId, @Nullable Throwable exception, Collection<Entry> entries2, String format) {
        this.component = component;
        this.level = level;
        this.messageId = messageId;
        this.clusterId = clusterId;
        this.exception = exception;
        this.entries = entries2;
        this.format = format;
    }

    public ClusterId getClusterId() {
        return this.clusterId;
    }

    public Component getComponent() {
        return this.component;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getMessageId() {
        return this.messageId;
    }

    @Nullable
    public Throwable getException() {
        return this.exception;
    }

    public Collection<Entry> getEntries() {
        return this.entries;
    }

    public StructuredLogMessage toStructuredLogMessage() {
        List nullableEntries = this.entries.stream().filter(entry -> entry.getValue() != null).collect(Collectors.toList());
        return new StructuredLogMessage(nullableEntries);
    }

    public UnstructuredLogMessage toUnstructuredLogMessage() {
        return new UnstructuredLogMessage();
    }

    public static enum Component {
        COMMAND,
        CONNECTION;

    }

    public static enum Level {
        DEBUG;

    }

    public static final class StructuredLogMessage {
        private final Collection<Entry> entries;

        private StructuredLogMessage(Collection<Entry> entries2) {
            entries2.forEach(entry -> Assertions.assertNotNull(entry.getValue()));
            this.entries = entries2;
        }

        public Collection<Entry> getEntries() {
            return this.entries;
        }
    }

    public final class UnstructuredLogMessage {
        public String interpolate() {
            Iterator iterator2 = LogMessage.this.entries.iterator();
            StringBuilder builder = new StringBuilder();
            int s2 = 0;
            for (int i = 0; i < LogMessage.this.format.length(); ++i) {
                char curr = LogMessage.this.format.charAt(i);
                if (curr == '[' || curr == '{') {
                    Object value = ((Entry)iterator2.next()).getValue();
                    builder.append(LogMessage.this.format, s2, i);
                    if (curr == '{') {
                        builder.append(value);
                    } else if (value == null) {
                        i = LogMessage.this.format.indexOf(93, i);
                    } else {
                        int openBrace = LogMessage.this.format.indexOf(123, i);
                        builder.append(LogMessage.this.format, i + 1, openBrace);
                        builder.append(value);
                        i = openBrace + 1;
                    }
                    s2 = i + 1;
                    continue;
                }
                if (curr != ']' && curr != '}') continue;
                if (curr == ']') {
                    builder.append(LogMessage.this.format, s2, i);
                }
                s2 = i + 1;
            }
            builder.append(LogMessage.this.format, s2, LogMessage.this.format.length());
            return builder.toString();
        }
    }

    public static final class Entry {
        private final Name name;
        private final Object value;

        public Entry(Name name, @Nullable Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name.getValue();
        }

        @Nullable
        public Object getValue() {
            return this.value;
        }

        public static enum Name {
            SERVER_HOST("serverHost"),
            SERVER_PORT("serverPort"),
            COMMAND_NAME("commandName"),
            REQUEST_ID("requestId"),
            OPERATION_ID("operationId"),
            SERVICE_ID("serviceId"),
            SERVER_CONNECTION_ID("serverConnectionId"),
            DRIVER_CONNECTION_ID("driverConnectionId"),
            DURATION_MS("durationMS"),
            DATABASE_NAME("databaseName"),
            REPLY("reply"),
            COMMAND_CONTENT("command"),
            REASON_DESCRIPTION("reason"),
            ERROR_DESCRIPTION("error"),
            MAX_IDLE_TIME_MS("maxIdleTimeMS"),
            MIN_POOL_SIZE("minPoolSize"),
            MAX_POOL_SIZE("maxPoolSize"),
            MAX_CONNECTING("maxConnecting"),
            WAIT_QUEUE_TIMEOUT_MS("waitQueueTimeoutMS");

            private final String value;

            public String getValue() {
                return this.value;
            }

            private Name(String value) {
                this.value = value;
            }
        }
    }
}

