/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.operation;

import com.willfp.eco.libs.bson.BsonBoolean;
import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonInt32;
import com.willfp.eco.libs.bson.BsonInt64;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.mongodb.lang.Nullable;

final class DocumentHelper {
    private DocumentHelper() {
    }

    static void putIfTrue(BsonDocument command2, String key, boolean condition) {
        if (condition) {
            command2.put(key, BsonBoolean.TRUE);
        }
    }

    static void putIfFalse(BsonDocument command2, String key, boolean condition) {
        if (!condition) {
            command2.put(key, BsonBoolean.FALSE);
        }
    }

    static void putIfNotNullOrEmpty(BsonDocument command2, String key, @Nullable BsonDocument documentValue) {
        if (documentValue != null && !documentValue.isEmpty()) {
            command2.put(key, documentValue);
        }
    }

    static void putIfNotNull(BsonDocument command2, String key, @Nullable BsonValue value) {
        if (value != null) {
            command2.put(key, value);
        }
    }

    static void putIfNotNull(BsonDocument command2, String key, @Nullable String value) {
        if (value != null) {
            command2.put(key, new BsonString(value));
        }
    }

    static void putIfNotZero(BsonDocument command2, String key, int value) {
        if (value != 0) {
            command2.put(key, new BsonInt32(value));
        }
    }

    static void putIfNotZero(BsonDocument command2, String key, long value) {
        if (value != 0L) {
            command2.put(key, new BsonInt64(value));
        }
    }
}

