/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.operation;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.mongodb.ExplainVerbosity;
import com.willfp.eco.libs.mongodb.MongoInternalException;
import com.willfp.eco.libs.mongodb.lang.Nullable;

final class ExplainHelper {
    static BsonDocument asExplainCommand(BsonDocument command2, @Nullable ExplainVerbosity explainVerbosity) {
        BsonDocument explainCommand = new BsonDocument("explain", command2);
        if (explainVerbosity != null) {
            explainCommand.append("verbosity", ExplainHelper.getVerbosityAsString(explainVerbosity));
        }
        return explainCommand;
    }

    private static BsonString getVerbosityAsString(ExplainVerbosity explainVerbosity) {
        switch (explainVerbosity) {
            case QUERY_PLANNER: {
                return new BsonString("queryPlanner");
            }
            case EXECUTION_STATS: {
                return new BsonString("executionStats");
            }
            case ALL_PLANS_EXECUTIONS: {
                return new BsonString("allPlansExecution");
            }
        }
        throw new MongoInternalException(String.format("Unsupported explain verbosity %s", new Object[]{explainVerbosity}));
    }

    private ExplainHelper() {
    }
}

