/*
 * Decompiled with CFR 0.152.
 */
package com.willfp.eco.libs.mongodb.internal.operation;

import com.willfp.eco.libs.bson.BsonDocument;
import com.willfp.eco.libs.bson.BsonNumber;
import com.willfp.eco.libs.bson.BsonString;
import com.willfp.eco.libs.bson.BsonValue;
import com.willfp.eco.libs.bson.codecs.configuration.CodecRegistry;
import com.willfp.eco.libs.mongodb.client.model.IndexModel;
import java.util.ArrayList;
import java.util.List;

public final class IndexHelper {
    public static List<String> getIndexNames(List<IndexModel> indexes, CodecRegistry codecRegistry) {
        ArrayList<String> indexNames = new ArrayList<String>(indexes.size());
        for (IndexModel index : indexes) {
            String name = index.getOptions().getName();
            if (name != null) {
                indexNames.add(name);
                continue;
            }
            indexNames.add(IndexHelper.generateIndexName(index.getKeys().toBsonDocument(BsonDocument.class, codecRegistry)));
        }
        return indexNames;
    }

    public static String generateIndexName(BsonDocument index) {
        StringBuilder indexName2 = new StringBuilder();
        for (String keyNames : index.keySet()) {
            if (indexName2.length() != 0) {
                indexName2.append('_');
            }
            indexName2.append(keyNames).append('_');
            BsonValue ascOrDescValue = index.get(keyNames);
            if (ascOrDescValue instanceof BsonNumber) {
                indexName2.append(((BsonNumber)ascOrDescValue).intValue());
                continue;
            }
            if (!(ascOrDescValue instanceof BsonString)) continue;
            indexName2.append(((BsonString)ascOrDescValue).getValue().replace(' ', '_'));
        }
        return indexName2.toString();
    }

    private IndexHelper() {
    }
}

